@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagecache.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Active Directory admin credentials used to join the HPC Cache to a domain.
 * @property password Plain text password of the Active Directory domain administrator. This value is stored encrypted and not returned on response.
 * @property username Username of the Active Directory domain administrator. This value is stored encrypted and not returned on response.
 */
public data class CacheActiveDirectorySettingsResponseCredentials(
    public val password: String? = null,
    public val username: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.storagecache.outputs.CacheActiveDirectorySettingsResponseCredentials):
            CacheActiveDirectorySettingsResponseCredentials =
            CacheActiveDirectorySettingsResponseCredentials(
                password = javaType.password().map({ args0 -> args0 }).orElse(null),
                username = javaType.username(),
            )
    }
}
