@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagecache.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Properties describing the software upgrade state of the cache.
 * @property currentFirmwareVersion Version string of the firmware currently installed on this cache.
 * @property firmwareUpdateDeadline Time at which the pending firmware update will automatically be installed on the cache.
 * @property firmwareUpdateStatus True if there is a firmware update ready to install on this cache. The firmware will automatically be installed after firmwareUpdateDeadline if not triggered earlier via the upgrade operation.
 * @property lastFirmwareUpdate Time of the last successful firmware update.
 * @property pendingFirmwareVersion When firmwareUpdateAvailable is true, this field holds the version string for the update.
 */
public data class CacheUpgradeStatusResponse(
    public val currentFirmwareVersion: String,
    public val firmwareUpdateDeadline: String,
    public val firmwareUpdateStatus: String,
    public val lastFirmwareUpdate: String,
    public val pendingFirmwareVersion: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.storagecache.outputs.CacheUpgradeStatusResponse):
            CacheUpgradeStatusResponse = CacheUpgradeStatusResponse(
            currentFirmwareVersion = javaType.currentFirmwareVersion(),
            firmwareUpdateDeadline = javaType.firmwareUpdateDeadline(),
            firmwareUpdateStatus = javaType.firmwareUpdateStatus(),
            lastFirmwareUpdate = javaType.lastFirmwareUpdate(),
            pendingFirmwareVersion = javaType.pendingFirmwareVersion(),
        )
    }
}
