@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagecache.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 * Information about the number of available IP addresses that are required for the AML file system.
 * @property filesystemSubnetSize The number of available IP addresses that are required for the AML file system.
 */
public data class GetRequiredAmlFSSubnetsSizeResult(
    public val filesystemSubnetSize: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.storagecache.outputs.GetRequiredAmlFSSubnetsSizeResult):
            GetRequiredAmlFSSubnetsSizeResult = GetRequiredAmlFSSubnetsSizeResult(
            filesystemSubnetSize = javaType.filesystemSubnetSize().map({ args0 -> args0 }).orElse(null),
        )
    }
}
