@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagecache.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Rule to place restrictions on portions of the cache namespace being presented to clients.
 * @property access Access allowed by this rule.
 * @property anonymousGID GID value that replaces 0 when rootSquash is true. This will use the value of anonymousUID if not provided.
 * @property anonymousUID UID value that replaces 0 when rootSquash is true. 65534 will be used if not provided.
 * @property filter Filter applied to the scope for this rule. The filter's format depends on its scope. 'default' scope matches all clients and has no filter value. 'network' scope takes a filter in CIDR format (for example, 10.99.1.0/24). 'host' takes an IP address or fully qualified domain name as filter. If a client does not match any filter rule and there is no default rule, access is denied.
 * @property rootSquash Map root accesses to anonymousUID and anonymousGID.
 * @property scope Scope for this rule. The scope and filter determine which clients match the rule.
 * @property submountAccess For the default policy, allow access to subdirectories under the root export. If this is set to no, clients can only mount the path '/'. If set to yes, clients can mount a deeper path, like '/a/b'.
 * @property suid Allow SUID semantics.
 */
public data class NfsAccessRuleResponse(
    public val access: String,
    public val anonymousGID: String? = null,
    public val anonymousUID: String? = null,
    public val filter: String? = null,
    public val rootSquash: Boolean? = null,
    public val scope: String,
    public val submountAccess: Boolean? = null,
    public val suid: Boolean? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.storagecache.outputs.NfsAccessRuleResponse):
            NfsAccessRuleResponse = NfsAccessRuleResponse(
            access = javaType.access(),
            anonymousGID = javaType.anonymousGID().map({ args0 -> args0 }).orElse(null),
            anonymousUID = javaType.anonymousUID().map({ args0 -> args0 }).orElse(null),
            filter = javaType.filter().map({ args0 -> args0 }).orElse(null),
            rootSquash = javaType.rootSquash().map({ args0 -> args0 }).orElse(null),
            scope = javaType.scope(),
            submountAccess = javaType.submountAccess().map({ args0 -> args0 }).orElse(null),
            suid = javaType.suid().map({ args0 -> args0 }).orElse(null),
        )
    }
}
