@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagemover.kotlin

import com.pulumi.azurenative.storagemover.kotlin.outputs.AgentPropertiesResponseErrorDetails
import com.pulumi.azurenative.storagemover.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.storagemover.kotlin.outputs.AgentPropertiesResponseErrorDetails.Companion.toKotlin as agentPropertiesResponseErrorDetailsToKotlin
import com.pulumi.azurenative.storagemover.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Agent].
 */
@PulumiTagMarker
public class AgentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AgentArgs = AgentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AgentArgsBuilder.() -> Unit) {
        val builder = AgentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Agent {
        val builtJavaResource = com.pulumi.azurenative.storagemover.Agent(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Agent(builtJavaResource)
    }
}

/**
 * The Agent resource.
 * Azure REST API version: 2023-03-01. Prior API version in Azure Native 1.x: 2022-07-01-preview.
 * Other available API versions: 2023-07-01-preview, 2023-10-01.
 * ## Example Usage
 * ### Agents_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var agent = new AzureNative.StorageMover.Agent("agent", new()
 *     {
 *         AgentName = "examples-agentName",
 *         ArcResourceId = "/subscriptions/11111111-2222-3333-4444-555555555555/resourceGroups/examples-rg/providers/Microsoft.HybridCompute/machines/examples-hybridComputeName",
 *         ArcVmUuid = "3bb2c024-eba9-4d18-9e7a-1d772fcc5fe9",
 *         Description = "Example Agent Description",
 *         ResourceGroupName = "examples-rg",
 *         StorageMoverName = "examples-storageMoverName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storagemover/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storagemover.NewAgent(ctx, "agent", &storagemover.AgentArgs{
 * 			AgentName:         pulumi.String("examples-agentName"),
 * 			ArcResourceId:     pulumi.String("/subscriptions/11111111-2222-3333-4444-555555555555/resourceGroups/examples-rg/providers/Microsoft.HybridCompute/machines/examples-hybridComputeName"),
 * 			ArcVmUuid:         pulumi.String("3bb2c024-eba9-4d18-9e7a-1d772fcc5fe9"),
 * 			Description:       pulumi.String("Example Agent Description"),
 * 			ResourceGroupName: pulumi.String("examples-rg"),
 * 			StorageMoverName:  pulumi.String("examples-storageMoverName"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storagemover.Agent;
 * import com.pulumi.azurenative.storagemover.AgentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var agent = new Agent("agent", AgentArgs.builder()
 *             .agentName("examples-agentName")
 *             .arcResourceId("/subscriptions/11111111-2222-3333-4444-555555555555/resourceGroups/examples-rg/providers/Microsoft.HybridCompute/machines/examples-hybridComputeName")
 *             .arcVmUuid("3bb2c024-eba9-4d18-9e7a-1d772fcc5fe9")
 *             .description("Example Agent Description")
 *             .resourceGroupName("examples-rg")
 *             .storageMoverName("examples-storageMoverName")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:storagemover:Agent examples-agentName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorageMover/storageMovers/{storageMoverName}/agents/{agentName}
 * ```
 */
public class Agent internal constructor(
    override val javaResource: com.pulumi.azurenative.storagemover.Agent,
) : KotlinCustomResource(javaResource, AgentMapper) {
    /**
     * The Agent status.
     */
    public val agentStatus: Output<String>
        get() = javaResource.agentStatus().applyValue({ args0 -> args0 })

    /**
     * The Agent version.
     */
    public val agentVersion: Output<String>
        get() = javaResource.agentVersion().applyValue({ args0 -> args0 })

    /**
     * The fully qualified resource ID of the Hybrid Compute resource for the Agent.
     */
    public val arcResourceId: Output<String>
        get() = javaResource.arcResourceId().applyValue({ args0 -> args0 })

    /**
     * The VM UUID of the Hybrid Compute resource for the Agent.
     */
    public val arcVmUuid: Output<String>
        get() = javaResource.arcVmUuid().applyValue({ args0 -> args0 })

    /**
     * A description for the Agent.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val errorDetails: Output<AgentPropertiesResponseErrorDetails>
        get() = javaResource.errorDetails().applyValue({ args0 ->
            args0.let({ args0 ->
                agentPropertiesResponseErrorDetailsToKotlin(args0)
            })
        })

    /**
     * The last updated time of the Agent status.
     */
    public val lastStatusUpdate: Output<String>
        get() = javaResource.lastStatusUpdate().applyValue({ args0 -> args0 })

    /**
     * Local IP address reported by the Agent.
     */
    public val localIPAddress: Output<String>
        get() = javaResource.localIPAddress().applyValue({ args0 -> args0 })

    /**
     * Available memory reported by the Agent, in MB.
     */
    public val memoryInMB: Output<Double>
        get() = javaResource.memoryInMB().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Available compute cores reported by the Agent.
     */
    public val numberOfCores: Output<Double>
        get() = javaResource.numberOfCores().applyValue({ args0 -> args0 })

    /**
     * The provisioning state of this resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Resource system metadata.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Uptime of the Agent in seconds.
     */
    public val uptimeInSeconds: Output<Double>
        get() = javaResource.uptimeInSeconds().applyValue({ args0 -> args0 })
}

public object AgentMapper : ResourceMapper<Agent> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.storagemover.Agent::class == javaResource::class

    override fun map(javaResource: Resource): Agent = Agent(
        javaResource as
            com.pulumi.azurenative.storagemover.Agent,
    )
}

/**
 * @see [Agent].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Agent].
 */
public suspend fun agent(name: String, block: suspend AgentResourceBuilder.() -> Unit): Agent {
    val builder = AgentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Agent].
 * @param name The _unique_ name of the resulting resource.
 */
public fun agent(name: String): Agent {
    val builder = AgentResourceBuilder()
    builder.name(name)
    return builder.build()
}
