@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagemover.kotlin

import com.pulumi.azurenative.storagemover.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.storagemover.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [JobDefinition].
 */
@PulumiTagMarker
public class JobDefinitionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: JobDefinitionArgs = JobDefinitionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend JobDefinitionArgsBuilder.() -> Unit) {
        val builder = JobDefinitionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): JobDefinition {
        val builtJavaResource =
            com.pulumi.azurenative.storagemover.JobDefinition(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return JobDefinition(builtJavaResource)
    }
}

/**
 * The Job Definition resource.
 * Azure REST API version: 2023-03-01. Prior API version in Azure Native 1.x: 2022-07-01-preview.
 * Other available API versions: 2023-07-01-preview, 2023-10-01.
 * ## Example Usage
 * ### JobDefinitions_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var jobDefinition = new AzureNative.StorageMover.JobDefinition("jobDefinition", new()
 *     {
 *         AgentName = "migration-agent",
 *         CopyMode = AzureNative.StorageMover.CopyMode.Additive,
 *         Description = "Example Job Definition Description",
 *         JobDefinitionName = "examples-jobDefinitionName",
 *         ProjectName = "examples-projectName",
 *         ResourceGroupName = "examples-rg",
 *         SourceName = "examples-sourceEndpointName",
 *         SourceSubpath = "/",
 *         StorageMoverName = "examples-storageMoverName",
 *         TargetName = "examples-targetEndpointName",
 *         TargetSubpath = "/",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storagemover/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storagemover.NewJobDefinition(ctx, "jobDefinition", &storagemover.JobDefinitionArgs{
 * 			AgentName:         pulumi.String("migration-agent"),
 * 			CopyMode:          pulumi.String(storagemover.CopyModeAdditive),
 * 			Description:       pulumi.String("Example Job Definition Description"),
 * 			JobDefinitionName: pulumi.String("examples-jobDefinitionName"),
 * 			ProjectName:       pulumi.String("examples-projectName"),
 * 			ResourceGroupName: pulumi.String("examples-rg"),
 * 			SourceName:        pulumi.String("examples-sourceEndpointName"),
 * 			SourceSubpath:     pulumi.String("/"),
 * 			StorageMoverName:  pulumi.String("examples-storageMoverName"),
 * 			TargetName:        pulumi.String("examples-targetEndpointName"),
 * 			TargetSubpath:     pulumi.String("/"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storagemover.JobDefinition;
 * import com.pulumi.azurenative.storagemover.JobDefinitionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var jobDefinition = new JobDefinition("jobDefinition", JobDefinitionArgs.builder()
 *             .agentName("migration-agent")
 *             .copyMode("Additive")
 *             .description("Example Job Definition Description")
 *             .jobDefinitionName("examples-jobDefinitionName")
 *             .projectName("examples-projectName")
 *             .resourceGroupName("examples-rg")
 *             .sourceName("examples-sourceEndpointName")
 *             .sourceSubpath("/")
 *             .storageMoverName("examples-storageMoverName")
 *             .targetName("examples-targetEndpointName")
 *             .targetSubpath("/")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:storagemover:JobDefinition examples-jobDefinitionName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorageMover/storageMovers/{storageMoverName}/projects/{projectName}/jobDefinitions/{jobDefinitionName}
 * ```
 */
public class JobDefinition internal constructor(
    override val javaResource: com.pulumi.azurenative.storagemover.JobDefinition,
) : KotlinCustomResource(javaResource, JobDefinitionMapper) {
    /**
     * Name of the Agent to assign for new Job Runs of this Job Definition.
     */
    public val agentName: Output<String>?
        get() = javaResource.agentName().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Fully qualified resource id of the Agent to assign for new Job Runs of this Job Definition.
     */
    public val agentResourceId: Output<String>
        get() = javaResource.agentResourceId().applyValue({ args0 -> args0 })

    /**
     * Strategy to use for copy.
     */
    public val copyMode: Output<String>
        get() = javaResource.copyMode().applyValue({ args0 -> args0 })

    /**
     * A description for the Job Definition.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the Job Run in a non-terminal state, if exists.
     */
    public val latestJobRunName: Output<String>
        get() = javaResource.latestJobRunName().applyValue({ args0 -> args0 })

    /**
     * The fully qualified resource ID of the Job Run in a non-terminal state, if exists.
     */
    public val latestJobRunResourceId: Output<String>
        get() = javaResource.latestJobRunResourceId().applyValue({ args0 -> args0 })

    /**
     * The current status of the Job Run in a non-terminal state, if exists.
     */
    public val latestJobRunStatus: Output<String>
        get() = javaResource.latestJobRunStatus().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioning state of this resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The name of the source Endpoint.
     */
    public val sourceName: Output<String>
        get() = javaResource.sourceName().applyValue({ args0 -> args0 })

    /**
     * Fully qualified resource ID of the source Endpoint.
     */
    public val sourceResourceId: Output<String>
        get() = javaResource.sourceResourceId().applyValue({ args0 -> args0 })

    /**
     * The subpath to use when reading from the source Endpoint.
     */
    public val sourceSubpath: Output<String>?
        get() = javaResource.sourceSubpath().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource system metadata.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The name of the target Endpoint.
     */
    public val targetName: Output<String>
        get() = javaResource.targetName().applyValue({ args0 -> args0 })

    /**
     * Fully qualified resource ID of the target Endpoint.
     */
    public val targetResourceId: Output<String>
        get() = javaResource.targetResourceId().applyValue({ args0 -> args0 })

    /**
     * The subpath to use when writing to the target Endpoint.
     */
    public val targetSubpath: Output<String>?
        get() = javaResource.targetSubpath().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object JobDefinitionMapper : ResourceMapper<JobDefinition> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.storagemover.JobDefinition::class == javaResource::class

    override fun map(javaResource: Resource): JobDefinition = JobDefinition(
        javaResource as
            com.pulumi.azurenative.storagemover.JobDefinition,
    )
}

/**
 * @see [JobDefinition].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [JobDefinition].
 */
public suspend fun jobDefinition(
    name: String,
    block: suspend JobDefinitionResourceBuilder.() -> Unit,
): JobDefinition {
    val builder = JobDefinitionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [JobDefinition].
 * @param name The _unique_ name of the resulting resource.
 */
public fun jobDefinition(name: String): JobDefinition {
    val builder = JobDefinitionResourceBuilder()
    builder.name(name)
    return builder.build()
}
