@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagemover.kotlin.inputs

import com.pulumi.azurenative.storagemover.inputs.NfsMountEndpointPropertiesArgs.builder
import com.pulumi.azurenative.storagemover.kotlin.enums.NfsVersion
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property description A description for the Endpoint.
 * @property endpointType The Endpoint resource type.
 * Expected value is 'NfsMount'.
 * @property export The directory being exported from the server.
 * @property host The host name or IP address of the server exporting the file system.
 * @property nfsVersion The NFS protocol version.
 */
public data class NfsMountEndpointPropertiesArgs(
    public val description: Output<String>? = null,
    public val endpointType: Output<String>,
    public val export: Output<String>,
    public val host: Output<String>,
    public val nfsVersion: Output<Either<String, NfsVersion>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storagemover.inputs.NfsMountEndpointPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.storagemover.inputs.NfsMountEndpointPropertiesArgs =
        com.pulumi.azurenative.storagemover.inputs.NfsMountEndpointPropertiesArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .endpointType(endpointType.applyValue({ args0 -> args0 }))
            .export(export.applyValue({ args0 -> args0 }))
            .host(host.applyValue({ args0 -> args0 }))
            .nfsVersion(
                nfsVersion?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [NfsMountEndpointPropertiesArgs].
 */
@PulumiTagMarker
public class NfsMountEndpointPropertiesArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var endpointType: Output<String>? = null

    private var export: Output<String>? = null

    private var host: Output<String>? = null

    private var nfsVersion: Output<Either<String, NfsVersion>>? = null

    /**
     * @param value A description for the Endpoint.
     */
    @JvmName("itayolopxpxjwfve")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The Endpoint resource type.
     * Expected value is 'NfsMount'.
     */
    @JvmName("tsoryfqflodsphje")
    public suspend fun endpointType(`value`: Output<String>) {
        this.endpointType = value
    }

    /**
     * @param value The directory being exported from the server.
     */
    @JvmName("ferumesjntpmiyls")
    public suspend fun export(`value`: Output<String>) {
        this.export = value
    }

    /**
     * @param value The host name or IP address of the server exporting the file system.
     */
    @JvmName("bkcactlvmghbhkgb")
    public suspend fun host(`value`: Output<String>) {
        this.host = value
    }

    /**
     * @param value The NFS protocol version.
     */
    @JvmName("ecaavaiemtmwylwg")
    public suspend fun nfsVersion(`value`: Output<Either<String, NfsVersion>>) {
        this.nfsVersion = value
    }

    /**
     * @param value A description for the Endpoint.
     */
    @JvmName("tsqbpxrmoiiqkhgq")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The Endpoint resource type.
     * Expected value is 'NfsMount'.
     */
    @JvmName("iwuownnemranaomh")
    public suspend fun endpointType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endpointType = mapped
    }

    /**
     * @param value The directory being exported from the server.
     */
    @JvmName("ldedlxwsbkaglpmg")
    public suspend fun export(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.export = mapped
    }

    /**
     * @param value The host name or IP address of the server exporting the file system.
     */
    @JvmName("joeqdwpumbqrrkuf")
    public suspend fun host(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.host = mapped
    }

    /**
     * @param value The NFS protocol version.
     */
    @JvmName("fdkeirtwfrkcgfmx")
    public suspend fun nfsVersion(`value`: Either<String, NfsVersion>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nfsVersion = mapped
    }

    /**
     * @param value The NFS protocol version.
     */
    @JvmName("oqpelpyicfdywnjv")
    public fun nfsVersion(`value`: String) {
        val toBeMapped = Either.ofLeft<String, NfsVersion>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nfsVersion = mapped
    }

    /**
     * @param value The NFS protocol version.
     */
    @JvmName("ycikffeoswvhsbwj")
    public fun nfsVersion(`value`: NfsVersion) {
        val toBeMapped = Either.ofRight<String, NfsVersion>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nfsVersion = mapped
    }

    internal fun build(): NfsMountEndpointPropertiesArgs = NfsMountEndpointPropertiesArgs(
        description = description,
        endpointType = endpointType ?: throw PulumiNullFieldException("endpointType"),
        export = export ?: throw PulumiNullFieldException("export"),
        host = host ?: throw PulumiNullFieldException("host"),
        nfsVersion = nfsVersion,
    )
}
