@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagepool.kotlin

import com.pulumi.azurenative.storagepool.kotlin.outputs.DiskResponse
import com.pulumi.azurenative.storagepool.kotlin.outputs.SystemMetadataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.storagepool.kotlin.outputs.DiskResponse.Companion.toKotlin as diskResponseToKotlin
import com.pulumi.azurenative.storagepool.kotlin.outputs.SystemMetadataResponse.Companion.toKotlin as systemMetadataResponseToKotlin

/**
 * Builder for [DiskPool].
 */
@PulumiTagMarker
public class DiskPoolResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DiskPoolArgs = DiskPoolArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DiskPoolArgsBuilder.() -> Unit) {
        val builder = DiskPoolArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DiskPool {
        val builtJavaResource = com.pulumi.azurenative.storagepool.DiskPool(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DiskPool(builtJavaResource)
    }
}

/**
 * Response for Disk Pool request.
 * Azure REST API version: 2021-08-01. Prior API version in Azure Native 1.x: 2020-03-15-preview.
 * Other available API versions: 2020-03-15-preview.
 * ## Example Usage
 * ### Create or Update Disk pool
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var diskPool = new AzureNative.StoragePool.DiskPool("diskPool", new()
 *     {
 *         AvailabilityZones = new[]
 *         {
 *             "1",
 *         },
 *         DiskPoolName = "myDiskPool",
 *         Disks = new[]
 *         {
 *             new AzureNative.StoragePool.Inputs.DiskArgs
 *             {
 *                 Id = "/subscriptions/11111111-1111-1111-1111-111111111111/resourceGroups/myResourceGroup/providers/Microsoft.Compute/disks/vm-name_DataDisk_0",
 *             },
 *             new AzureNative.StoragePool.Inputs.DiskArgs
 *             {
 *                 Id = "/subscriptions/11111111-1111-1111-1111-111111111111/resourceGroups/myResourceGroup/providers/Microsoft.Compute/disks/vm-name_DataDisk_1",
 *             },
 *         },
 *         Location = "westus",
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.StoragePool.Inputs.SkuArgs
 *         {
 *             Name = "Basic_V1",
 *             Tier = "Basic",
 *         },
 *         SubnetId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/myvnet/subnets/mysubnet",
 *         Tags =
 *         {
 *             { "key", "value" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storagepool/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storagepool.NewDiskPool(ctx, "diskPool", &storagepool.DiskPoolArgs{
 * 			AvailabilityZones: pulumi.StringArray{
 * 				pulumi.String("1"),
 * 			},
 * 			DiskPoolName: pulumi.String("myDiskPool"),
 * 			Disks: storagepool.DiskArray{
 * 				&storagepool.DiskArgs{
 * 					Id: pulumi.String("/subscriptions/11111111-1111-1111-1111-111111111111/resourceGroups/myResourceGroup/providers/Microsoft.Compute/disks/vm-name_DataDisk_0"),
 * 				},
 * 				&storagepool.DiskArgs{
 * 					Id: pulumi.String("/subscriptions/11111111-1111-1111-1111-111111111111/resourceGroups/myResourceGroup/providers/Microsoft.Compute/disks/vm-name_DataDisk_1"),
 * 				},
 * 			},
 * 			Location:          pulumi.String("westus"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &storagepool.SkuArgs{
 * 				Name: pulumi.String("Basic_V1"),
 * 				Tier: pulumi.String("Basic"),
 * 			},
 * 			SubnetId: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/myvnet/subnets/mysubnet"),
 * 			Tags: pulumi.StringMap{
 * 				"key": pulumi.String("value"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storagepool.DiskPool;
 * import com.pulumi.azurenative.storagepool.DiskPoolArgs;
 * import com.pulumi.azurenative.storagepool.inputs.DiskArgs;
 * import com.pulumi.azurenative.storagepool.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var diskPool = new DiskPool("diskPool", DiskPoolArgs.builder()
 *             .availabilityZones("1")
 *             .diskPoolName("myDiskPool")
 *             .disks(
 *                 DiskArgs.builder()
 *                     .id("/subscriptions/11111111-1111-1111-1111-111111111111/resourceGroups/myResourceGroup/providers/Microsoft.Compute/disks/vm-name_DataDisk_0")
 *                     .build(),
 *                 DiskArgs.builder()
 *                     .id("/subscriptions/11111111-1111-1111-1111-111111111111/resourceGroups/myResourceGroup/providers/Microsoft.Compute/disks/vm-name_DataDisk_1")
 *                     .build())
 *             .location("westus")
 *             .resourceGroupName("myResourceGroup")
 *             .sku(SkuArgs.builder()
 *                 .name("Basic_V1")
 *                 .tier("Basic")
 *                 .build())
 *             .subnetId("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/myvnet/subnets/mysubnet")
 *             .tags(Map.of("key", "value"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:storagepool:DiskPool myDiskPool /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StoragePool/diskPools/{diskPoolName}
 * ```
 */
public class DiskPool internal constructor(
    override val javaResource: com.pulumi.azurenative.storagepool.DiskPool,
) : KotlinCustomResource(javaResource, DiskPoolMapper) {
    /**
     * List of additional capabilities for Disk Pool.
     */
    public val additionalCapabilities: Output<List<String>>?
        get() = javaResource.additionalCapabilities().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Logical zone for Disk Pool resource; example: ["1"].
     */
    public val availabilityZones: Output<List<String>>
        get() = javaResource.availabilityZones().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * List of Azure Managed Disks to attach to a Disk Pool.
     */
    public val disks: Output<List<DiskResponse>>?
        get() = javaResource.disks().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> diskResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Azure resource id. Indicates if this resource is managed by another Azure resource.
     */
    public val managedBy: Output<String>
        get() = javaResource.managedBy().applyValue({ args0 -> args0 })

    /**
     * List of Azure resource ids that manage this resource.
     */
    public val managedByExtended: Output<List<String>>
        get() = javaResource.managedByExtended().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * State of the operation on the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Operational status of the Disk Pool.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Azure Resource ID of a Subnet for the Disk Pool.
     */
    public val subnetId: Output<String>
        get() = javaResource.subnetId().applyValue({ args0 -> args0 })

    /**
     * Resource metadata required by ARM RPC
     */
    public val systemData: Output<SystemMetadataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemMetadataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Sku tier
     */
    public val tier: Output<String>?
        get() = javaResource.tier().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object DiskPoolMapper : ResourceMapper<DiskPool> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.storagepool.DiskPool::class == javaResource::class

    override fun map(javaResource: Resource): DiskPool = DiskPool(
        javaResource as
            com.pulumi.azurenative.storagepool.DiskPool,
    )
}

/**
 * @see [DiskPool].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DiskPool].
 */
public suspend fun diskPool(name: String, block: suspend DiskPoolResourceBuilder.() -> Unit):
    DiskPool {
    val builder = DiskPoolResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DiskPool].
 * @param name The _unique_ name of the resulting resource.
 */
public fun diskPool(name: String): DiskPool {
    val builder = DiskPoolResourceBuilder()
    builder.name(name)
    return builder.build()
}
