@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagepool.kotlin

import com.pulumi.azurenative.storagepool.StoragepoolFunctions.getDiskPoolPlain
import com.pulumi.azurenative.storagepool.StoragepoolFunctions.getIscsiTargetPlain
import com.pulumi.azurenative.storagepool.kotlin.inputs.GetDiskPoolPlainArgs
import com.pulumi.azurenative.storagepool.kotlin.inputs.GetDiskPoolPlainArgsBuilder
import com.pulumi.azurenative.storagepool.kotlin.inputs.GetIscsiTargetPlainArgs
import com.pulumi.azurenative.storagepool.kotlin.inputs.GetIscsiTargetPlainArgsBuilder
import com.pulumi.azurenative.storagepool.kotlin.outputs.GetDiskPoolResult
import com.pulumi.azurenative.storagepool.kotlin.outputs.GetIscsiTargetResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.storagepool.kotlin.outputs.GetDiskPoolResult.Companion.toKotlin as getDiskPoolResultToKotlin
import com.pulumi.azurenative.storagepool.kotlin.outputs.GetIscsiTargetResult.Companion.toKotlin as getIscsiTargetResultToKotlin

public object StoragepoolFunctions {
    /**
     * Get a Disk pool.
     * Azure REST API version: 2021-08-01.
     * Other available API versions: 2020-03-15-preview.
     * @param argument null
     * @return Response for Disk Pool request.
     */
    public suspend fun getDiskPool(argument: GetDiskPoolPlainArgs): GetDiskPoolResult =
        getDiskPoolResultToKotlin(getDiskPoolPlain(argument.toJava()).await())

    /**
     * @see [getDiskPool].
     * @param diskPoolName The name of the Disk Pool.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Response for Disk Pool request.
     */
    public suspend fun getDiskPool(diskPoolName: String, resourceGroupName: String):
        GetDiskPoolResult {
        val argument = GetDiskPoolPlainArgs(
            diskPoolName = diskPoolName,
            resourceGroupName = resourceGroupName,
        )
        return getDiskPoolResultToKotlin(getDiskPoolPlain(argument.toJava()).await())
    }

    /**
     * @see [getDiskPool].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;storagepool&#46;kotlin&#46;inputs&#46;GetDiskPoolPlainArgs].
     * @return Response for Disk Pool request.
     */
    public suspend fun getDiskPool(argument: suspend GetDiskPoolPlainArgsBuilder.() -> Unit):
        GetDiskPoolResult {
        val builder = GetDiskPoolPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDiskPoolResultToKotlin(getDiskPoolPlain(builtArgument.toJava()).await())
    }

    /**
     * Get an iSCSI Target.
     * Azure REST API version: 2021-08-01.
     * Other available API versions: 2020-03-15-preview.
     * @param argument null
     * @return Response for iSCSI Target requests.
     */
    public suspend fun getIscsiTarget(argument: GetIscsiTargetPlainArgs): GetIscsiTargetResult =
        getIscsiTargetResultToKotlin(getIscsiTargetPlain(argument.toJava()).await())

    /**
     * @see [getIscsiTarget].
     * @param diskPoolName The name of the Disk Pool.
     * @param iscsiTargetName The name of the iSCSI Target.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Response for iSCSI Target requests.
     */
    public suspend fun getIscsiTarget(
        diskPoolName: String,
        iscsiTargetName: String,
        resourceGroupName: String,
    ): GetIscsiTargetResult {
        val argument = GetIscsiTargetPlainArgs(
            diskPoolName = diskPoolName,
            iscsiTargetName = iscsiTargetName,
            resourceGroupName = resourceGroupName,
        )
        return getIscsiTargetResultToKotlin(getIscsiTargetPlain(argument.toJava()).await())
    }

    /**
     * @see [getIscsiTarget].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;storagepool&#46;kotlin&#46;inputs&#46;GetIscsiTargetPlainArgs].
     * @return Response for iSCSI Target requests.
     */
    public suspend fun getIscsiTarget(argument: suspend GetIscsiTargetPlainArgsBuilder.() -> Unit):
        GetIscsiTargetResult {
        val builder = GetIscsiTargetPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getIscsiTargetResultToKotlin(getIscsiTargetPlain(builtArgument.toJava()).await())
    }
}
