@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagepool.kotlin.inputs

import com.pulumi.azurenative.storagepool.inputs.IscsiLunArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * LUN to expose the Azure Managed Disk.
 * @property managedDiskAzureResourceId Azure Resource ID of the Managed Disk.
 * @property name User defined name for iSCSI LUN; example: "lun0"
 */
public data class IscsiLunArgs(
    public val managedDiskAzureResourceId: Output<String>,
    public val name: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.storagepool.inputs.IscsiLunArgs> {
    override fun toJava(): com.pulumi.azurenative.storagepool.inputs.IscsiLunArgs =
        com.pulumi.azurenative.storagepool.inputs.IscsiLunArgs.builder()
            .managedDiskAzureResourceId(managedDiskAzureResourceId.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IscsiLunArgs].
 */
@PulumiTagMarker
public class IscsiLunArgsBuilder internal constructor() {
    private var managedDiskAzureResourceId: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value Azure Resource ID of the Managed Disk.
     */
    @JvmName("smedevjjmimahxed")
    public suspend fun managedDiskAzureResourceId(`value`: Output<String>) {
        this.managedDiskAzureResourceId = value
    }

    /**
     * @param value User defined name for iSCSI LUN; example: "lun0"
     */
    @JvmName("budmdlrdxobdksxt")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Azure Resource ID of the Managed Disk.
     */
    @JvmName("mrkctdpfytykstuy")
    public suspend fun managedDiskAzureResourceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.managedDiskAzureResourceId = mapped
    }

    /**
     * @param value User defined name for iSCSI LUN; example: "lun0"
     */
    @JvmName("oqtfpoxamsbnqywj")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): IscsiLunArgs = IscsiLunArgs(
        managedDiskAzureResourceId = managedDiskAzureResourceId ?: throw
            PulumiNullFieldException("managedDiskAzureResourceId"),
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
