@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagepool.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Response for iSCSI Target requests.
 * @property aclMode Mode for Target connectivity.
 * @property endpoints List of private IPv4 addresses to connect to the iSCSI Target.
 * @property id Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property luns List of LUNs to be exposed through iSCSI Target.
 * @property managedBy Azure resource id. Indicates if this resource is managed by another Azure resource.
 * @property managedByExtended List of Azure resource ids that manage this resource.
 * @property name The name of the resource
 * @property port The port used by iSCSI Target portal group.
 * @property provisioningState State of the operation on the resource.
 * @property sessions List of identifiers for active sessions on the iSCSI target
 * @property staticAcls Access Control List (ACL) for an iSCSI Target; defines LUN masking policy
 * @property status Operational status of the iSCSI Target.
 * @property systemData Resource metadata required by ARM RPC
 * @property targetIqn iSCSI Target IQN (iSCSI Qualified Name); example: "iqn.2005-03.org.iscsi:server".
 * @property type The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
 */
public data class GetIscsiTargetResult(
    public val aclMode: String,
    public val endpoints: List<String>? = null,
    public val id: String,
    public val luns: List<IscsiLunResponse>? = null,
    public val managedBy: String,
    public val managedByExtended: List<String>,
    public val name: String,
    public val port: Int? = null,
    public val provisioningState: String,
    public val sessions: List<String>,
    public val staticAcls: List<AclResponse>? = null,
    public val status: String,
    public val systemData: SystemMetadataResponse,
    public val targetIqn: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storagepool.outputs.GetIscsiTargetResult):
            GetIscsiTargetResult = GetIscsiTargetResult(
            aclMode = javaType.aclMode(),
            endpoints = javaType.endpoints().map({ args0 -> args0 }),
            id = javaType.id(),
            luns = javaType.luns().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storagepool.kotlin.outputs.IscsiLunResponse.Companion.toKotlin(args0)
                })
            }),
            managedBy = javaType.managedBy(),
            managedByExtended = javaType.managedByExtended().map({ args0 -> args0 }),
            name = javaType.name(),
            port = javaType.port().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            sessions = javaType.sessions().map({ args0 -> args0 }),
            staticAcls = javaType.staticAcls().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storagepool.kotlin.outputs.AclResponse.Companion.toKotlin(args0)
                })
            }),
            status = javaType.status(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.storagepool.kotlin.outputs.SystemMetadataResponse.Companion.toKotlin(args0)
            }),
            targetIqn = javaType.targetIqn(),
            type = javaType.type(),
        )
    }
}
