@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagesync.kotlin

import com.pulumi.azurenative.storagesync.kotlin.outputs.ServerEndpointCloudTieringStatusResponse
import com.pulumi.azurenative.storagesync.kotlin.outputs.ServerEndpointRecallStatusResponse
import com.pulumi.azurenative.storagesync.kotlin.outputs.ServerEndpointSyncStatusResponse
import com.pulumi.azurenative.storagesync.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.storagesync.kotlin.outputs.ServerEndpointCloudTieringStatusResponse.Companion.toKotlin as serverEndpointCloudTieringStatusResponseToKotlin
import com.pulumi.azurenative.storagesync.kotlin.outputs.ServerEndpointRecallStatusResponse.Companion.toKotlin as serverEndpointRecallStatusResponseToKotlin
import com.pulumi.azurenative.storagesync.kotlin.outputs.ServerEndpointSyncStatusResponse.Companion.toKotlin as serverEndpointSyncStatusResponseToKotlin
import com.pulumi.azurenative.storagesync.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [ServerEndpoint].
 */
@PulumiTagMarker
public class ServerEndpointResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ServerEndpointArgs = ServerEndpointArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ServerEndpointArgsBuilder.() -> Unit) {
        val builder = ServerEndpointArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ServerEndpoint {
        val builtJavaResource =
            com.pulumi.azurenative.storagesync.ServerEndpoint(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ServerEndpoint(builtJavaResource)
    }
}

/**
 * Server Endpoint object.
 * Azure REST API version: 2022-06-01. Prior API version in Azure Native 1.x: 2020-03-01.
 * Other available API versions: 2017-06-05-preview, 2018-04-02, 2018-07-01, 2018-10-01, 2019-10-01, 2022-09-01.
 * ## Example Usage
 * ### ServerEndpoints_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var serverEndpoint = new AzureNative.StorageSync.ServerEndpoint("serverEndpoint", new()
 *     {
 *         CloudTiering = AzureNative.StorageSync.FeatureStatus.Off,
 *         InitialDownloadPolicy = AzureNative.StorageSync.InitialDownloadPolicy.NamespaceThenModifiedFiles,
 *         InitialUploadPolicy = AzureNative.StorageSync.InitialUploadPolicy.ServerAuthoritative,
 *         LocalCacheMode = AzureNative.StorageSync.LocalCacheMode.UpdateLocallyCachedFiles,
 *         OfflineDataTransfer = AzureNative.StorageSync.FeatureStatus.@On,
 *         OfflineDataTransferShareName = "myfileshare",
 *         ResourceGroupName = "SampleResourceGroup_1",
 *         ServerEndpointName = "SampleServerEndpoint_1",
 *         ServerLocalPath = "D:\\SampleServerEndpoint_1",
 *         ServerResourceId = "/subscriptions/52b8da2f-61e0-4a1f-8dde-336911f367fb/resourceGroups/SampleResourceGroup_1/providers/Microsoft.StorageSync/storageSyncServices/SampleStorageSyncService_1/registeredServers/080d4133-bdb5-40a0-96a0-71a6057bfe9a",
 *         StorageSyncServiceName = "SampleStorageSyncService_1",
 *         SyncGroupName = "SampleSyncGroup_1",
 *         TierFilesOlderThanDays = 0,
 *         VolumeFreeSpacePercent = 100,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storagesync/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storagesync.NewServerEndpoint(ctx, "serverEndpoint", &storagesync.ServerEndpointArgs{
 * 			CloudTiering:                 pulumi.String(storagesync.FeatureStatusOff),
 * 			InitialDownloadPolicy:        pulumi.String(storagesync.InitialDownloadPolicyNamespaceThenModifiedFiles),
 * 			InitialUploadPolicy:          pulumi.String(storagesync.InitialUploadPolicyServerAuthoritative),
 * 			LocalCacheMode:               pulumi.String(storagesync.LocalCacheModeUpdateLocallyCachedFiles),
 * 			OfflineDataTransfer:          pulumi.String(storagesync.FeatureStatusOn),
 * 			OfflineDataTransferShareName: pulumi.String("myfileshare"),
 * 			ResourceGroupName:            pulumi.String("SampleResourceGroup_1"),
 * 			ServerEndpointName:           pulumi.String("SampleServerEndpoint_1"),
 * 			ServerLocalPath:              pulumi.String("D:\\SampleServerEndpoint_1"),
 * 			ServerResourceId:             pulumi.String("/subscriptions/52b8da2f-61e0-4a1f-8dde-336911f367fb/resourceGroups/SampleResourceGroup_1/providers/Microsoft.StorageSync/storageSyncServices/SampleStorageSyncService_1/registeredServers/080d4133-bdb5-40a0-96a0-71a6057bfe9a"),
 * 			StorageSyncServiceName:       pulumi.String("SampleStorageSyncService_1"),
 * 			SyncGroupName:                pulumi.String("SampleSyncGroup_1"),
 * 			TierFilesOlderThanDays:       pulumi.Int(0),
 * 			VolumeFreeSpacePercent:       pulumi.Int(100),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storagesync.ServerEndpoint;
 * import com.pulumi.azurenative.storagesync.ServerEndpointArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var serverEndpoint = new ServerEndpoint("serverEndpoint", ServerEndpointArgs.builder()
 *             .cloudTiering("off")
 *             .initialDownloadPolicy("NamespaceThenModifiedFiles")
 *             .initialUploadPolicy("ServerAuthoritative")
 *             .localCacheMode("UpdateLocallyCachedFiles")
 *             .offlineDataTransfer("on")
 *             .offlineDataTransferShareName("myfileshare")
 *             .resourceGroupName("SampleResourceGroup_1")
 *             .serverEndpointName("SampleServerEndpoint_1")
 *             .serverLocalPath("D:\\SampleServerEndpoint_1")
 *             .serverResourceId("/subscriptions/52b8da2f-61e0-4a1f-8dde-336911f367fb/resourceGroups/SampleResourceGroup_1/providers/Microsoft.StorageSync/storageSyncServices/SampleStorageSyncService_1/registeredServers/080d4133-bdb5-40a0-96a0-71a6057bfe9a")
 *             .storageSyncServiceName("SampleStorageSyncService_1")
 *             .syncGroupName("SampleSyncGroup_1")
 *             .tierFilesOlderThanDays(0)
 *             .volumeFreeSpacePercent(100)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:storagesync:ServerEndpoint SampleServerEndpoint_1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorageSync/storageSyncServices/{storageSyncServiceName}/syncGroups/{syncGroupName}/serverEndpoints/{serverEndpointName}
 * ```
 */
public class ServerEndpoint internal constructor(
    override val javaResource: com.pulumi.azurenative.storagesync.ServerEndpoint,
) : KotlinCustomResource(javaResource, ServerEndpointMapper) {
    /**
     * Cloud Tiering.
     */
    public val cloudTiering: Output<String>?
        get() = javaResource.cloudTiering().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Cloud tiering status. Only populated if cloud tiering is enabled.
     */
    public val cloudTieringStatus: Output<ServerEndpointCloudTieringStatusResponse>
        get() = javaResource.cloudTieringStatus().applyValue({ args0 ->
            args0.let({ args0 ->
                serverEndpointCloudTieringStatusResponseToKotlin(args0)
            })
        })

    /**
     * Friendly Name
     */
    public val friendlyName: Output<String>?
        get() = javaResource.friendlyName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Policy for how namespace and files are recalled during FastDr.
     */
    public val initialDownloadPolicy: Output<String>?
        get() = javaResource.initialDownloadPolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Policy for how the initial upload sync session is performed.
     */
    public val initialUploadPolicy: Output<String>?
        get() = javaResource.initialUploadPolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource Last Operation Name
     */
    public val lastOperationName: Output<String>
        get() = javaResource.lastOperationName().applyValue({ args0 -> args0 })

    /**
     * ServerEndpoint lastWorkflowId
     */
    public val lastWorkflowId: Output<String>
        get() = javaResource.lastWorkflowId().applyValue({ args0 -> args0 })

    /**
     * Policy for enabling follow-the-sun business models: link local cache to cloud behavior to pre-populate before local access.
     */
    public val localCacheMode: Output<String>?
        get() = javaResource.localCacheMode().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Offline data transfer
     */
    public val offlineDataTransfer: Output<String>?
        get() = javaResource.offlineDataTransfer().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Offline data transfer share name
     */
    public val offlineDataTransferShareName: Output<String>?
        get() = javaResource.offlineDataTransferShareName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Offline data transfer storage account resource ID
     */
    public val offlineDataTransferStorageAccountResourceId: Output<String>
        get() = javaResource.offlineDataTransferStorageAccountResourceId().applyValue({ args0 -> args0 })

    /**
     * Offline data transfer storage account tenant ID
     */
    public val offlineDataTransferStorageAccountTenantId: Output<String>
        get() = javaResource.offlineDataTransferStorageAccountTenantId().applyValue({ args0 -> args0 })

    /**
     * ServerEndpoint Provisioning State
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Recall status. Only populated if cloud tiering is enabled.
     */
    public val recallStatus: Output<ServerEndpointRecallStatusResponse>
        get() = javaResource.recallStatus().applyValue({ args0 ->
            args0.let({ args0 ->
                serverEndpointRecallStatusResponseToKotlin(args0)
            })
        })

    /**
     * Server Local path.
     */
    public val serverLocalPath: Output<String>?
        get() = javaResource.serverLocalPath().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Server name
     */
    public val serverName: Output<String>
        get() = javaResource.serverName().applyValue({ args0 -> args0 })

    /**
     * Server Resource Id.
     */
    public val serverResourceId: Output<String>?
        get() = javaResource.serverResourceId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Server Endpoint sync status
     */
    public val syncStatus: Output<ServerEndpointSyncStatusResponse>
        get() = javaResource.syncStatus().applyValue({ args0 ->
            args0.let({ args0 ->
                serverEndpointSyncStatusResponseToKotlin(args0)
            })
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Tier files older than days.
     */
    public val tierFilesOlderThanDays: Output<Int>?
        get() = javaResource.tierFilesOlderThanDays().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Level of free space to be maintained by Cloud Tiering if it is enabled.
     */
    public val volumeFreeSpacePercent: Output<Int>?
        get() = javaResource.volumeFreeSpacePercent().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object ServerEndpointMapper : ResourceMapper<ServerEndpoint> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.storagesync.ServerEndpoint::class == javaResource::class

    override fun map(javaResource: Resource): ServerEndpoint = ServerEndpoint(
        javaResource as
            com.pulumi.azurenative.storagesync.ServerEndpoint,
    )
}

/**
 * @see [ServerEndpoint].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ServerEndpoint].
 */
public suspend fun serverEndpoint(
    name: String,
    block: suspend ServerEndpointResourceBuilder.() -> Unit,
): ServerEndpoint {
    val builder = ServerEndpointResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ServerEndpoint].
 * @param name The _unique_ name of the resulting resource.
 */
public fun serverEndpoint(name: String): ServerEndpoint {
    val builder = ServerEndpointResourceBuilder()
    builder.name(name)
    return builder.build()
}
