@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagesync.kotlin

import com.pulumi.azurenative.storagesync.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.storagesync.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [SyncGroup].
 */
@PulumiTagMarker
public class SyncGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SyncGroupArgs = SyncGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SyncGroupArgsBuilder.() -> Unit) {
        val builder = SyncGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): SyncGroup {
        val builtJavaResource = com.pulumi.azurenative.storagesync.SyncGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return SyncGroup(builtJavaResource)
    }
}

/**
 * Sync Group object.
 * Azure REST API version: 2022-06-01. Prior API version in Azure Native 1.x: 2020-03-01.
 * Other available API versions: 2017-06-05-preview, 2018-04-02, 2022-09-01.
 * ## Example Usage
 * ### SyncGroups_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var syncGroup = new AzureNative.StorageSync.SyncGroup("syncGroup", new()
 *     {
 *         ResourceGroupName = "SampleResourceGroup_1",
 *         StorageSyncServiceName = "SampleStorageSyncService_1",
 *         SyncGroupName = "SampleSyncGroup_1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storagesync/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storagesync.NewSyncGroup(ctx, "syncGroup", &storagesync.SyncGroupArgs{
 * 			ResourceGroupName:      pulumi.String("SampleResourceGroup_1"),
 * 			StorageSyncServiceName: pulumi.String("SampleStorageSyncService_1"),
 * 			SyncGroupName:          pulumi.String("SampleSyncGroup_1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storagesync.SyncGroup;
 * import com.pulumi.azurenative.storagesync.SyncGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var syncGroup = new SyncGroup("syncGroup", SyncGroupArgs.builder()
 *             .resourceGroupName("SampleResourceGroup_1")
 *             .storageSyncServiceName("SampleStorageSyncService_1")
 *             .syncGroupName("SampleSyncGroup_1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:storagesync:SyncGroup SampleSyncGroup_1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorageSync/storageSyncServices/{storageSyncServiceName}/syncGroups/{syncGroupName}
 * ```
 */
public class SyncGroup internal constructor(
    override val javaResource: com.pulumi.azurenative.storagesync.SyncGroup,
) : KotlinCustomResource(javaResource, SyncGroupMapper) {
    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Sync group status
     */
    public val syncGroupStatus: Output<String>
        get() = javaResource.syncGroupStatus().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Unique Id
     */
    public val uniqueId: Output<String>
        get() = javaResource.uniqueId().applyValue({ args0 -> args0 })
}

public object SyncGroupMapper : ResourceMapper<SyncGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.storagesync.SyncGroup::class == javaResource::class

    override fun map(javaResource: Resource): SyncGroup = SyncGroup(
        javaResource as
            com.pulumi.azurenative.storagesync.SyncGroup,
    )
}

/**
 * @see [SyncGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SyncGroup].
 */
public suspend fun syncGroup(name: String, block: suspend SyncGroupResourceBuilder.() -> Unit):
    SyncGroup {
    val builder = SyncGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SyncGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun syncGroup(name: String): SyncGroup {
    val builder = SyncGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
