@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagesync.kotlin.inputs

import com.pulumi.azurenative.storagesync.inputs.GetStorageSyncServicePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property storageSyncServiceName Name of Storage Sync Service resource.
 */
public data class GetStorageSyncServicePlainArgs(
    public val resourceGroupName: String,
    public val storageSyncServiceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.storagesync.inputs.GetStorageSyncServicePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.storagesync.inputs.GetStorageSyncServicePlainArgs =
        com.pulumi.azurenative.storagesync.inputs.GetStorageSyncServicePlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .storageSyncServiceName(storageSyncServiceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetStorageSyncServicePlainArgs].
 */
@PulumiTagMarker
public class GetStorageSyncServicePlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var storageSyncServiceName: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("bniudevksqykiepc")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of Storage Sync Service resource.
     */
    @JvmName("wyfjpfuivgoyltel")
    public suspend fun storageSyncServiceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.storageSyncServiceName = mapped
    }

    internal fun build(): GetStorageSyncServicePlainArgs = GetStorageSyncServicePlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        storageSyncServiceName = storageSyncServiceName ?: throw
            PulumiNullFieldException("storageSyncServiceName"),
    )
}
