@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagesync.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Registered Server resource.
 * @property agentVersion Registered Server Agent Version
 * @property agentVersionExpirationDate Registered Server Agent Version Expiration Date
 * @property agentVersionStatus Registered Server Agent Version Status
 * @property clusterId Registered Server clusterId
 * @property clusterName Registered Server clusterName
 * @property discoveryEndpointUri Resource discoveryEndpointUri
 * @property friendlyName Friendly Name
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property lastHeartBeat Registered Server last heart beat
 * @property lastOperationName Resource Last Operation Name
 * @property lastWorkflowId Registered Server lastWorkflowId
 * @property managementEndpointUri Management Endpoint Uri
 * @property monitoringConfiguration Monitoring Configuration
 * @property monitoringEndpointUri Telemetry Endpoint Uri
 * @property name The name of the resource
 * @property provisioningState Registered Server Provisioning State
 * @property resourceLocation Resource Location
 * @property serverCertificate Registered Server Certificate
 * @property serverId Registered Server serverId
 * @property serverManagementErrorCode Registered Server Management Error Code
 * @property serverName Server name
 * @property serverOSVersion Registered Server OS Version
 * @property serverRole Registered Server serverRole
 * @property serviceLocation Service Location
 * @property storageSyncServiceUid Registered Server storageSyncServiceUid
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetRegisteredServerResult(
    public val agentVersion: String? = null,
    public val agentVersionExpirationDate: String,
    public val agentVersionStatus: String,
    public val clusterId: String? = null,
    public val clusterName: String? = null,
    public val discoveryEndpointUri: String? = null,
    public val friendlyName: String? = null,
    public val id: String,
    public val lastHeartBeat: String? = null,
    public val lastOperationName: String? = null,
    public val lastWorkflowId: String? = null,
    public val managementEndpointUri: String? = null,
    public val monitoringConfiguration: String? = null,
    public val monitoringEndpointUri: String? = null,
    public val name: String,
    public val provisioningState: String? = null,
    public val resourceLocation: String? = null,
    public val serverCertificate: String? = null,
    public val serverId: String? = null,
    public val serverManagementErrorCode: Int? = null,
    public val serverName: String,
    public val serverOSVersion: String? = null,
    public val serverRole: String? = null,
    public val serviceLocation: String? = null,
    public val storageSyncServiceUid: String? = null,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.storagesync.outputs.GetRegisteredServerResult):
            GetRegisteredServerResult = GetRegisteredServerResult(
            agentVersion = javaType.agentVersion().map({ args0 -> args0 }).orElse(null),
            agentVersionExpirationDate = javaType.agentVersionExpirationDate(),
            agentVersionStatus = javaType.agentVersionStatus(),
            clusterId = javaType.clusterId().map({ args0 -> args0 }).orElse(null),
            clusterName = javaType.clusterName().map({ args0 -> args0 }).orElse(null),
            discoveryEndpointUri = javaType.discoveryEndpointUri().map({ args0 -> args0 }).orElse(null),
            friendlyName = javaType.friendlyName().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            lastHeartBeat = javaType.lastHeartBeat().map({ args0 -> args0 }).orElse(null),
            lastOperationName = javaType.lastOperationName().map({ args0 -> args0 }).orElse(null),
            lastWorkflowId = javaType.lastWorkflowId().map({ args0 -> args0 }).orElse(null),
            managementEndpointUri = javaType.managementEndpointUri().map({ args0 -> args0 }).orElse(null),
            monitoringConfiguration = javaType.monitoringConfiguration().map({ args0 -> args0 }).orElse(null),
            monitoringEndpointUri = javaType.monitoringEndpointUri().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            provisioningState = javaType.provisioningState().map({ args0 -> args0 }).orElse(null),
            resourceLocation = javaType.resourceLocation().map({ args0 -> args0 }).orElse(null),
            serverCertificate = javaType.serverCertificate().map({ args0 -> args0 }).orElse(null),
            serverId = javaType.serverId().map({ args0 -> args0 }).orElse(null),
            serverManagementErrorCode = javaType.serverManagementErrorCode().map({ args0 ->
                args0
            }).orElse(null),
            serverName = javaType.serverName(),
            serverOSVersion = javaType.serverOSVersion().map({ args0 -> args0 }).orElse(null),
            serverRole = javaType.serverRole().map({ args0 -> args0 }).orElse(null),
            serviceLocation = javaType.serviceLocation().map({ args0 -> args0 }).orElse(null),
            storageSyncServiceUid = javaType.storageSyncServiceUid().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.storagesync.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
