@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagesync.kotlin.outputs

import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Background data download activity object
 * @property downloadedBytes Running count of bytes downloaded
 * @property percentProgress Progress percentage
 * @property startedTimestamp Timestamp when the operation started
 * @property timestamp Timestamp when properties were updated
 */
public data class ServerEndpointBackgroundDataDownloadActivityResponse(
    public val downloadedBytes: Double,
    public val percentProgress: Int,
    public val startedTimestamp: String,
    public val timestamp: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.storagesync.outputs.ServerEndpointBackgroundDataDownloadActivityResponse):
            ServerEndpointBackgroundDataDownloadActivityResponse =
            ServerEndpointBackgroundDataDownloadActivityResponse(
                downloadedBytes = javaType.downloadedBytes(),
                percentProgress = javaType.percentProgress(),
                startedTimestamp = javaType.startedTimestamp(),
                timestamp = javaType.timestamp(),
            )
    }
}
