@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagesync.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Server endpoint recall status object.
 * @property lastUpdatedTimestamp Last updated timestamp
 * @property recallErrors Array of recall errors
 * @property totalRecallErrorsCount Total count of recall errors.
 */
public data class ServerEndpointRecallStatusResponse(
    public val lastUpdatedTimestamp: String,
    public val recallErrors: List<ServerEndpointRecallErrorResponse>,
    public val totalRecallErrorsCount: Double,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.storagesync.outputs.ServerEndpointRecallStatusResponse):
            ServerEndpointRecallStatusResponse = ServerEndpointRecallStatusResponse(
            lastUpdatedTimestamp = javaType.lastUpdatedTimestamp(),
            recallErrors = javaType.recallErrors().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storagesync.kotlin.outputs.ServerEndpointRecallErrorResponse.Companion.toKotlin(args0)
                })
            }),
            totalRecallErrorsCount = javaType.totalRecallErrorsCount(),
        )
    }
}
