@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagesync.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * Server Endpoint sync status
 * @property backgroundDataDownloadActivity Background data download activity
 * @property combinedHealth Combined Health Status.
 * @property downloadActivity Download sync activity
 * @property downloadHealth Download Health Status.
 * @property downloadStatus Download Status
 * @property lastUpdatedTimestamp Last Updated Timestamp
 * @property offlineDataTransferStatus Offline Data Transfer State
 * @property syncActivity Sync activity
 * @property totalPersistentFilesNotSyncingCount Total count of persistent files not syncing (combined upload + download).
 * @property uploadActivity Upload sync activity
 * @property uploadHealth Upload Health Status.
 * @property uploadStatus Upload Status
 */
public data class ServerEndpointSyncStatusResponse(
    public val backgroundDataDownloadActivity: ServerEndpointBackgroundDataDownloadActivityResponse,
    public val combinedHealth: String,
    public val downloadActivity: ServerEndpointSyncActivityStatusResponse,
    public val downloadHealth: String,
    public val downloadStatus: ServerEndpointSyncSessionStatusResponse,
    public val lastUpdatedTimestamp: String,
    public val offlineDataTransferStatus: String,
    public val syncActivity: String,
    public val totalPersistentFilesNotSyncingCount: Double,
    public val uploadActivity: ServerEndpointSyncActivityStatusResponse,
    public val uploadHealth: String,
    public val uploadStatus: ServerEndpointSyncSessionStatusResponse,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.storagesync.outputs.ServerEndpointSyncStatusResponse):
            ServerEndpointSyncStatusResponse = ServerEndpointSyncStatusResponse(
            backgroundDataDownloadActivity = javaType.backgroundDataDownloadActivity().let({ args0 ->
                com.pulumi.azurenative.storagesync.kotlin.outputs.ServerEndpointBackgroundDataDownloadActivityResponse.Companion.toKotlin(args0)
            }),
            combinedHealth = javaType.combinedHealth(),
            downloadActivity = javaType.downloadActivity().let({ args0 ->
                com.pulumi.azurenative.storagesync.kotlin.outputs.ServerEndpointSyncActivityStatusResponse.Companion.toKotlin(args0)
            }),
            downloadHealth = javaType.downloadHealth(),
            downloadStatus = javaType.downloadStatus().let({ args0 ->
                com.pulumi.azurenative.storagesync.kotlin.outputs.ServerEndpointSyncSessionStatusResponse.Companion.toKotlin(args0)
            }),
            lastUpdatedTimestamp = javaType.lastUpdatedTimestamp(),
            offlineDataTransferStatus = javaType.offlineDataTransferStatus(),
            syncActivity = javaType.syncActivity(),
            totalPersistentFilesNotSyncingCount = javaType.totalPersistentFilesNotSyncingCount(),
            uploadActivity = javaType.uploadActivity().let({ args0 ->
                com.pulumi.azurenative.storagesync.kotlin.outputs.ServerEndpointSyncActivityStatusResponse.Companion.toKotlin(args0)
            }),
            uploadHealth = javaType.uploadHealth(),
            uploadStatus = javaType.uploadStatus().let({ args0 ->
                com.pulumi.azurenative.storagesync.kotlin.outputs.ServerEndpointSyncSessionStatusResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
