@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storsimple.kotlin

import com.pulumi.azurenative.storsimple.BandwidthSettingArgs.builder
import com.pulumi.azurenative.storsimple.kotlin.enums.Kind
import com.pulumi.azurenative.storsimple.kotlin.inputs.BandwidthScheduleArgs
import com.pulumi.azurenative.storsimple.kotlin.inputs.BandwidthScheduleArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The bandwidth setting.
 * Azure REST API version: 2017-06-01. Prior API version in Azure Native 1.x: 2017-06-01.
 * ## Example Usage
 * ### BandwidthSettingsCreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var bandwidthSetting = new AzureNative.StorSimple.BandwidthSetting("bandwidthSetting", new()
 *     {
 *         BandwidthSettingName = "BWSForTest",
 *         ManagerName = "ManagerForSDKTest1",
 *         ResourceGroupName = "ResourceGroupForSDKTest",
 *         Schedules = new[]
 *         {
 *             new AzureNative.StorSimple.Inputs.BandwidthScheduleArgs
 *             {
 *                 Days = new[]
 *                 {
 *                     AzureNative.StorSimple.DayOfWeek.Saturday,
 *                     AzureNative.StorSimple.DayOfWeek.Sunday,
 *                 },
 *                 RateInMbps = 10,
 *                 Start = new AzureNative.StorSimple.Inputs.TimeArgs
 *                 {
 *                     Hours = 10,
 *                     Minutes = 0,
 *                     Seconds = 0,
 *                 },
 *                 Stop = new AzureNative.StorSimple.Inputs.TimeArgs
 *                 {
 *                     Hours = 20,
 *                     Minutes = 0,
 *                     Seconds = 0,
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storsimple/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storsimple.NewBandwidthSetting(ctx, "bandwidthSetting", &storsimple.BandwidthSettingArgs{
 * 			BandwidthSettingName: pulumi.String("BWSForTest"),
 * 			ManagerName:          pulumi.String("ManagerForSDKTest1"),
 * 			ResourceGroupName:    pulumi.String("ResourceGroupForSDKTest"),
 * 			Schedules: storsimple.BandwidthScheduleArray{
 * 				&storsimple.BandwidthScheduleArgs{
 * 					Days: storsimple.DayOfWeekArray{
 * 						storsimple.DayOfWeekSaturday,
 * 						storsimple.DayOfWeekSunday,
 * 					},
 * 					RateInMbps: pulumi.Int(10),
 * 					Start: &storsimple.TimeArgs{
 * 						Hours:   pulumi.Int(10),
 * 						Minutes: pulumi.Int(0),
 * 						Seconds: pulumi.Int(0),
 * 					},
 * 					Stop: &storsimple.TimeArgs{
 * 						Hours:   pulumi.Int(20),
 * 						Minutes: pulumi.Int(0),
 * 						Seconds: pulumi.Int(0),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storsimple.BandwidthSetting;
 * import com.pulumi.azurenative.storsimple.BandwidthSettingArgs;
 * import com.pulumi.azurenative.storsimple.inputs.BandwidthScheduleArgs;
 * import com.pulumi.azurenative.storsimple.inputs.TimeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var bandwidthSetting = new BandwidthSetting("bandwidthSetting", BandwidthSettingArgs.builder()
 *             .bandwidthSettingName("BWSForTest")
 *             .managerName("ManagerForSDKTest1")
 *             .resourceGroupName("ResourceGroupForSDKTest")
 *             .schedules(BandwidthScheduleArgs.builder()
 *                 .days(
 *                     "Saturday",
 *                     "Sunday")
 *                 .rateInMbps(10)
 *                 .start(TimeArgs.builder()
 *                     .hours(10)
 *                     .minutes(0)
 *                     .seconds(0)
 *                     .build())
 *                 .stop(TimeArgs.builder()
 *                     .hours(20)
 *                     .minutes(0)
 *                     .seconds(0)
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:storsimple:BandwidthSetting BWSForTest /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/bandwidthSettings/{bandwidthSettingName}
 * ```
 * @property bandwidthSettingName The bandwidth setting name.
 * @property kind The Kind of the object. Currently only Series8000 is supported
 * @property managerName The manager name
 * @property resourceGroupName The resource group name
 * @property schedules The schedules.
 */
public data class BandwidthSettingArgs(
    public val bandwidthSettingName: Output<String>? = null,
    public val kind: Output<Kind>? = null,
    public val managerName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val schedules: Output<List<BandwidthScheduleArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storsimple.BandwidthSettingArgs> {
    override fun toJava(): com.pulumi.azurenative.storsimple.BandwidthSettingArgs =
        com.pulumi.azurenative.storsimple.BandwidthSettingArgs.builder()
            .bandwidthSettingName(bandwidthSettingName?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .managerName(managerName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .schedules(
                schedules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [BandwidthSettingArgs].
 */
@PulumiTagMarker
public class BandwidthSettingArgsBuilder internal constructor() {
    private var bandwidthSettingName: Output<String>? = null

    private var kind: Output<Kind>? = null

    private var managerName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var schedules: Output<List<BandwidthScheduleArgs>>? = null

    /**
     * @param value The bandwidth setting name.
     */
    @JvmName("ebfeafshqnfkkktb")
    public suspend fun bandwidthSettingName(`value`: Output<String>) {
        this.bandwidthSettingName = value
    }

    /**
     * @param value The Kind of the object. Currently only Series8000 is supported
     */
    @JvmName("gkgljapvvgofukrw")
    public suspend fun kind(`value`: Output<Kind>) {
        this.kind = value
    }

    /**
     * @param value The manager name
     */
    @JvmName("scxvwaucubrnrubd")
    public suspend fun managerName(`value`: Output<String>) {
        this.managerName = value
    }

    /**
     * @param value The resource group name
     */
    @JvmName("raiqthswbwbhvdso")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The schedules.
     */
    @JvmName("hlkchdwjxuevaxuy")
    public suspend fun schedules(`value`: Output<List<BandwidthScheduleArgs>>) {
        this.schedules = value
    }

    @JvmName("qownyqpquwvhoebu")
    public suspend fun schedules(vararg values: Output<BandwidthScheduleArgs>) {
        this.schedules = Output.all(values.asList())
    }

    /**
     * @param values The schedules.
     */
    @JvmName("kcrrigrufdphdxry")
    public suspend fun schedules(values: List<Output<BandwidthScheduleArgs>>) {
        this.schedules = Output.all(values)
    }

    /**
     * @param value The bandwidth setting name.
     */
    @JvmName("ogslsdhggusvbsvv")
    public suspend fun bandwidthSettingName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bandwidthSettingName = mapped
    }

    /**
     * @param value The Kind of the object. Currently only Series8000 is supported
     */
    @JvmName("dboewwrocjhtjxne")
    public suspend fun kind(`value`: Kind?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The manager name
     */
    @JvmName("jbevclxfopitqlpc")
    public suspend fun managerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managerName = mapped
    }

    /**
     * @param value The resource group name
     */
    @JvmName("ktmkflghlyfaecyh")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The schedules.
     */
    @JvmName("pxstpflxysdprxlb")
    public suspend fun schedules(`value`: List<BandwidthScheduleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schedules = mapped
    }

    /**
     * @param argument The schedules.
     */
    @JvmName("iyrxhlfwvprnyvch")
    public suspend fun schedules(argument: List<suspend BandwidthScheduleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            BandwidthScheduleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.schedules = mapped
    }

    /**
     * @param argument The schedules.
     */
    @JvmName("kwgkvbfxbvkwoplg")
    public suspend fun schedules(vararg argument: suspend BandwidthScheduleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            BandwidthScheduleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.schedules = mapped
    }

    /**
     * @param argument The schedules.
     */
    @JvmName("tqfataavxbnomgep")
    public suspend fun schedules(argument: suspend BandwidthScheduleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(BandwidthScheduleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.schedules = mapped
    }

    /**
     * @param values The schedules.
     */
    @JvmName("qfugiwnckfagasbp")
    public suspend fun schedules(vararg values: BandwidthScheduleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.schedules = mapped
    }

    internal fun build(): BandwidthSettingArgs = BandwidthSettingArgs(
        bandwidthSettingName = bandwidthSettingName,
        kind = kind,
        managerName = managerName,
        resourceGroupName = resourceGroupName,
        schedules = schedules,
    )
}
