@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storsimple.kotlin

import com.pulumi.azurenative.storsimple.ManagerArgs.builder
import com.pulumi.azurenative.storsimple.kotlin.inputs.ManagerIntrinsicSettingsArgs
import com.pulumi.azurenative.storsimple.kotlin.inputs.ManagerIntrinsicSettingsArgsBuilder
import com.pulumi.azurenative.storsimple.kotlin.inputs.ManagerSkuArgs
import com.pulumi.azurenative.storsimple.kotlin.inputs.ManagerSkuArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The StorSimple Manager.
 * Azure REST API version: 2017-06-01. Prior API version in Azure Native 1.x: 2017-06-01.
 * Other available API versions: 2016-10-01.
 * ## Example Usage
 * ### ManagersCreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var manager = new AzureNative.StorSimple.Manager("manager", new()
 *     {
 *         CisIntrinsicSettings = new AzureNative.StorSimple.Inputs.ManagerIntrinsicSettingsArgs
 *         {
 *             Type = AzureNative.StorSimple.ManagerType.GardaV1,
 *         },
 *         Location = "westus",
 *         ManagerName = "ManagerForSDKTest2",
 *         ResourceGroupName = "ResourceGroupForSDKTest",
 *         Sku = new AzureNative.StorSimple.Inputs.ManagerSkuArgs
 *         {
 *             Name = AzureNative.StorSimple.ManagerSkuType.Standard,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storsimple/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storsimple.NewManager(ctx, "manager", &storsimple.ManagerArgs{
 * 			CisIntrinsicSettings: &storsimple.ManagerIntrinsicSettingsArgs{
 * 				Type: storsimple.ManagerTypeGardaV1,
 * 			},
 * 			Location:          pulumi.String("westus"),
 * 			ManagerName:       pulumi.String("ManagerForSDKTest2"),
 * 			ResourceGroupName: pulumi.String("ResourceGroupForSDKTest"),
 * 			Sku: &storsimple.ManagerSkuArgs{
 * 				Name: storsimple.ManagerSkuTypeStandard,
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storsimple.Manager;
 * import com.pulumi.azurenative.storsimple.ManagerArgs;
 * import com.pulumi.azurenative.storsimple.inputs.ManagerIntrinsicSettingsArgs;
 * import com.pulumi.azurenative.storsimple.inputs.ManagerSkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var manager = new Manager("manager", ManagerArgs.builder()
 *             .cisIntrinsicSettings(ManagerIntrinsicSettingsArgs.builder()
 *                 .type("GardaV1")
 *                 .build())
 *             .location("westus")
 *             .managerName("ManagerForSDKTest2")
 *             .resourceGroupName("ResourceGroupForSDKTest")
 *             .sku(ManagerSkuArgs.builder()
 *                 .name("Standard")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:storsimple:Manager ManagerForSDKTest2 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}
 * ```
 * @property cisIntrinsicSettings Represents the type of StorSimple Manager.
 * @property location The geo location of the resource.
 * @property managerName The manager name
 * @property provisioningState Specifies the state of the resource as it is getting provisioned. Value of "Succeeded" means the Manager was successfully created.
 * @property resourceGroupName The resource group name
 * @property sku Specifies the Sku.
 * @property tags The tags attached to the resource.
 */
public data class ManagerArgs(
    public val cisIntrinsicSettings: Output<ManagerIntrinsicSettingsArgs>? = null,
    public val location: Output<String>? = null,
    public val managerName: Output<String>? = null,
    public val provisioningState: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sku: Output<ManagerSkuArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storsimple.ManagerArgs> {
    override fun toJava(): com.pulumi.azurenative.storsimple.ManagerArgs =
        com.pulumi.azurenative.storsimple.ManagerArgs.builder()
            .cisIntrinsicSettings(
                cisIntrinsicSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .managerName(managerName?.applyValue({ args0 -> args0 }))
            .provisioningState(provisioningState?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ManagerArgs].
 */
@PulumiTagMarker
public class ManagerArgsBuilder internal constructor() {
    private var cisIntrinsicSettings: Output<ManagerIntrinsicSettingsArgs>? = null

    private var location: Output<String>? = null

    private var managerName: Output<String>? = null

    private var provisioningState: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var sku: Output<ManagerSkuArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Represents the type of StorSimple Manager.
     */
    @JvmName("utsvtsbelxponuya")
    public suspend fun cisIntrinsicSettings(`value`: Output<ManagerIntrinsicSettingsArgs>) {
        this.cisIntrinsicSettings = value
    }

    /**
     * @param value The geo location of the resource.
     */
    @JvmName("kblbpqecfdrkahjg")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The manager name
     */
    @JvmName("itljjqkqwutbhpai")
    public suspend fun managerName(`value`: Output<String>) {
        this.managerName = value
    }

    /**
     * @param value Specifies the state of the resource as it is getting provisioned. Value of "Succeeded" means the Manager was successfully created.
     */
    @JvmName("xxlywukkfbyytpda")
    public suspend fun provisioningState(`value`: Output<String>) {
        this.provisioningState = value
    }

    /**
     * @param value The resource group name
     */
    @JvmName("rqicmxadrwplxofi")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Specifies the Sku.
     */
    @JvmName("xuxplhisjnbcwjtq")
    public suspend fun sku(`value`: Output<ManagerSkuArgs>) {
        this.sku = value
    }

    /**
     * @param value The tags attached to the resource.
     */
    @JvmName("kxwllhbcfugmxugw")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Represents the type of StorSimple Manager.
     */
    @JvmName("hgwsmqebvskshmeb")
    public suspend fun cisIntrinsicSettings(`value`: ManagerIntrinsicSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cisIntrinsicSettings = mapped
    }

    /**
     * @param argument Represents the type of StorSimple Manager.
     */
    @JvmName("wwoangpxtxtwirak")
    public suspend
    fun cisIntrinsicSettings(argument: suspend ManagerIntrinsicSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = ManagerIntrinsicSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.cisIntrinsicSettings = mapped
    }

    /**
     * @param value The geo location of the resource.
     */
    @JvmName("xewsohtqrslrlplr")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The manager name
     */
    @JvmName("jqpldtwkllvdwtar")
    public suspend fun managerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managerName = mapped
    }

    /**
     * @param value Specifies the state of the resource as it is getting provisioned. Value of "Succeeded" means the Manager was successfully created.
     */
    @JvmName("anuakumftswpikaf")
    public suspend fun provisioningState(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value The resource group name
     */
    @JvmName("ssjihcapflwiqqnf")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Specifies the Sku.
     */
    @JvmName("fenuhnwswpyxyufm")
    public suspend fun sku(`value`: ManagerSkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument Specifies the Sku.
     */
    @JvmName("yauiyemjjndhkdfk")
    public suspend fun sku(argument: suspend ManagerSkuArgsBuilder.() -> Unit) {
        val toBeMapped = ManagerSkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value The tags attached to the resource.
     */
    @JvmName("esljsgpupauiljit")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The tags attached to the resource.
     */
    @JvmName("vjitseqpntqtylfa")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ManagerArgs = ManagerArgs(
        cisIntrinsicSettings = cisIntrinsicSettings,
        location = location,
        managerName = managerName,
        provisioningState = provisioningState,
        resourceGroupName = resourceGroupName,
        sku = sku,
        tags = tags,
    )
}
