@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storsimple.kotlin

import com.pulumi.azurenative.storsimple.StorageAccountCredentialArgs.builder
import com.pulumi.azurenative.storsimple.kotlin.enums.Kind
import com.pulumi.azurenative.storsimple.kotlin.enums.SslStatus
import com.pulumi.azurenative.storsimple.kotlin.inputs.AsymmetricEncryptedSecretArgs
import com.pulumi.azurenative.storsimple.kotlin.inputs.AsymmetricEncryptedSecretArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The storage account credential.
 * Azure REST API version: 2017-06-01. Prior API version in Azure Native 1.x: 2017-06-01.
 * Other available API versions: 2016-10-01.
 * ## Example Usage
 * ### StorageAccountCredentialsCreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var storageAccountCredential = new AzureNative.StorSimple.StorageAccountCredential("storageAccountCredential", new()
 *     {
 *         AccessKey = new AzureNative.StorSimple.Inputs.AsymmetricEncryptedSecretArgs
 *         {
 *             EncryptionAlgorithm = AzureNative.StorSimple.EncryptionAlgorithm.RSAES_PKCS1_v_1_5,
 *             EncryptionCertThumbprint = "A872A2DF196AC7682EE24791E7DE2E2A360F5926",
 *             Value = "ATuJSkmrFk4h8r1jrZ4nd3nthLSddcguEO5QLO/NECUtTuB9kL4dNv3/jC4WOvFkeVr3x1UvfhlIeMmJBF1SMr6hR1JzD0xNU/TtQqUeXN7V3jk7I+2l67P9StuHWR6OMd3XOLwvznxOEQtEWpweDiobZU1ZiY03WafcGZFpV5j6tEoHeopoZ1J/GhPtkYmx+TqxzUN6qnir5rP3NSYiZciImP/qu8U9yUV/xpVRv39KvFc2Yr5SpKpMMRUj55XW10UnPer63M6KovF8X9Wi/fNnrZAs1Esl5XddZETGrW/e5B++VMJ6w0Q/uvPR+UBwrOU0804l0SzwdIe3qVVd0Q==",
 *         },
 *         EndPoint = "blob.core.windows.net",
 *         ManagerName = "ManagerForSDKTest1",
 *         ResourceGroupName = "ResourceGroupForSDKTest",
 *         SslStatus = AzureNative.StorSimple.SslStatus.Enabled,
 *         StorageAccountCredentialName = "SACForTest",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storsimple/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storsimple.NewStorageAccountCredential(ctx, "storageAccountCredential", &storsimple.StorageAccountCredentialArgs{
 * 			AccessKey: &storsimple.AsymmetricEncryptedSecretArgs{
 * 				EncryptionAlgorithm:      storsimple.EncryptionAlgorithm_RSAES_PKCS1_v_1_5,
 * 				EncryptionCertThumbprint: pulumi.String("A872A2DF196AC7682EE24791E7DE2E2A360F5926"),
 * 				Value:                    pulumi.String("ATuJSkmrFk4h8r1jrZ4nd3nthLSddcguEO5QLO/NECUtTuB9kL4dNv3/jC4WOvFkeVr3x1UvfhlIeMmJBF1SMr6hR1JzD0xNU/TtQqUeXN7V3jk7I+2l67P9StuHWR6OMd3XOLwvznxOEQtEWpweDiobZU1ZiY03WafcGZFpV5j6tEoHeopoZ1J/GhPtkYmx+TqxzUN6qnir5rP3NSYiZciImP/qu8U9yUV/xpVRv39KvFc2Yr5SpKpMMRUj55XW10UnPer63M6KovF8X9Wi/fNnrZAs1Esl5XddZETGrW/e5B++VMJ6w0Q/uvPR+UBwrOU0804l0SzwdIe3qVVd0Q=="),
 * 			},
 * 			EndPoint:                     pulumi.String("blob.core.windows.net"),
 * 			ManagerName:                  pulumi.String("ManagerForSDKTest1"),
 * 			ResourceGroupName:            pulumi.String("ResourceGroupForSDKTest"),
 * 			SslStatus:                    storsimple.SslStatusEnabled,
 * 			StorageAccountCredentialName: pulumi.String("SACForTest"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storsimple.StorageAccountCredential;
 * import com.pulumi.azurenative.storsimple.StorageAccountCredentialArgs;
 * import com.pulumi.azurenative.storsimple.inputs.AsymmetricEncryptedSecretArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var storageAccountCredential = new StorageAccountCredential("storageAccountCredential", StorageAccountCredentialArgs.builder()
 *             .accessKey(AsymmetricEncryptedSecretArgs.builder()
 *                 .encryptionAlgorithm("RSAES_PKCS1_v_1_5")
 *                 .encryptionCertThumbprint("A872A2DF196AC7682EE24791E7DE2E2A360F5926")
 *                 .value("ATuJSkmrFk4h8r1jrZ4nd3nthLSddcguEO5QLO/NECUtTuB9kL4dNv3/jC4WOvFkeVr3x1UvfhlIeMmJBF1SMr6hR1JzD0xNU/TtQqUeXN7V3jk7I+2l67P9StuHWR6OMd3XOLwvznxOEQtEWpweDiobZU1ZiY03WafcGZFpV5j6tEoHeopoZ1J/GhPtkYmx+TqxzUN6qnir5rP3NSYiZciImP/qu8U9yUV/xpVRv39KvFc2Yr5SpKpMMRUj55XW10UnPer63M6KovF8X9Wi/fNnrZAs1Esl5XddZETGrW/e5B++VMJ6w0Q/uvPR+UBwrOU0804l0SzwdIe3qVVd0Q==")
 *                 .build())
 *             .endPoint("blob.core.windows.net")
 *             .managerName("ManagerForSDKTest1")
 *             .resourceGroupName("ResourceGroupForSDKTest")
 *             .sslStatus("Enabled")
 *             .storageAccountCredentialName("SACForTest")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:storsimple:StorageAccountCredential SACForTest /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/storageAccountCredentials/{storageAccountCredentialName}
 * ```
 * @property accessKey The details of the storage account password.
 * @property endPoint The storage endpoint
 * @property kind The Kind of the object. Currently only Series8000 is supported
 * @property managerName The manager name
 * @property resourceGroupName The resource group name
 * @property sslStatus Signifies whether SSL needs to be enabled or not.
 * @property storageAccountCredentialName The storage account credential name.
 */
public data class StorageAccountCredentialArgs(
    public val accessKey: Output<AsymmetricEncryptedSecretArgs>? = null,
    public val endPoint: Output<String>? = null,
    public val kind: Output<Kind>? = null,
    public val managerName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sslStatus: Output<SslStatus>? = null,
    public val storageAccountCredentialName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storsimple.StorageAccountCredentialArgs> {
    override fun toJava(): com.pulumi.azurenative.storsimple.StorageAccountCredentialArgs =
        com.pulumi.azurenative.storsimple.StorageAccountCredentialArgs.builder()
            .accessKey(accessKey?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .endPoint(endPoint?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .managerName(managerName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sslStatus(sslStatus?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .storageAccountCredentialName(storageAccountCredentialName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StorageAccountCredentialArgs].
 */
@PulumiTagMarker
public class StorageAccountCredentialArgsBuilder internal constructor() {
    private var accessKey: Output<AsymmetricEncryptedSecretArgs>? = null

    private var endPoint: Output<String>? = null

    private var kind: Output<Kind>? = null

    private var managerName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var sslStatus: Output<SslStatus>? = null

    private var storageAccountCredentialName: Output<String>? = null

    /**
     * @param value The details of the storage account password.
     */
    @JvmName("pvxkbclthaatadbv")
    public suspend fun accessKey(`value`: Output<AsymmetricEncryptedSecretArgs>) {
        this.accessKey = value
    }

    /**
     * @param value The storage endpoint
     */
    @JvmName("jgfxfqfagtgqrrov")
    public suspend fun endPoint(`value`: Output<String>) {
        this.endPoint = value
    }

    /**
     * @param value The Kind of the object. Currently only Series8000 is supported
     */
    @JvmName("jyjnqgydrinhilvd")
    public suspend fun kind(`value`: Output<Kind>) {
        this.kind = value
    }

    /**
     * @param value The manager name
     */
    @JvmName("pwgiwadupknqssgu")
    public suspend fun managerName(`value`: Output<String>) {
        this.managerName = value
    }

    /**
     * @param value The resource group name
     */
    @JvmName("megnwiomjgvchioe")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Signifies whether SSL needs to be enabled or not.
     */
    @JvmName("wqahtociknhoyxaa")
    public suspend fun sslStatus(`value`: Output<SslStatus>) {
        this.sslStatus = value
    }

    /**
     * @param value The storage account credential name.
     */
    @JvmName("kswjthpcgeuqbgnp")
    public suspend fun storageAccountCredentialName(`value`: Output<String>) {
        this.storageAccountCredentialName = value
    }

    /**
     * @param value The details of the storage account password.
     */
    @JvmName("ljlpmxokkfyjojed")
    public suspend fun accessKey(`value`: AsymmetricEncryptedSecretArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessKey = mapped
    }

    /**
     * @param argument The details of the storage account password.
     */
    @JvmName("oqewypntlyvhlokt")
    public suspend fun accessKey(argument: suspend AsymmetricEncryptedSecretArgsBuilder.() -> Unit) {
        val toBeMapped = AsymmetricEncryptedSecretArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.accessKey = mapped
    }

    /**
     * @param value The storage endpoint
     */
    @JvmName("ishxviketviimlup")
    public suspend fun endPoint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endPoint = mapped
    }

    /**
     * @param value The Kind of the object. Currently only Series8000 is supported
     */
    @JvmName("xybfeliqnvynoynh")
    public suspend fun kind(`value`: Kind?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The manager name
     */
    @JvmName("tnotdmdmdikeltmy")
    public suspend fun managerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managerName = mapped
    }

    /**
     * @param value The resource group name
     */
    @JvmName("balcqtqopucgwojf")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Signifies whether SSL needs to be enabled or not.
     */
    @JvmName("ebqjcgghsdsqejvv")
    public suspend fun sslStatus(`value`: SslStatus?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sslStatus = mapped
    }

    /**
     * @param value The storage account credential name.
     */
    @JvmName("wtvgwgwfvkjkeppm")
    public suspend fun storageAccountCredentialName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccountCredentialName = mapped
    }

    internal fun build(): StorageAccountCredentialArgs = StorageAccountCredentialArgs(
        accessKey = accessKey,
        endPoint = endPoint,
        kind = kind,
        managerName = managerName,
        resourceGroupName = resourceGroupName,
        sslStatus = sslStatus,
        storageAccountCredentialName = storageAccountCredentialName,
    )
}
