@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storsimple.kotlin

import com.pulumi.azurenative.storsimple.kotlin.outputs.AsymmetricEncryptedSecretResponse
import com.pulumi.azurenative.storsimple.kotlin.outputs.AsymmetricEncryptedSecretResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [VolumeContainer].
 */
@PulumiTagMarker
public class VolumeContainerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VolumeContainerArgs = VolumeContainerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VolumeContainerArgsBuilder.() -> Unit) {
        val builder = VolumeContainerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): VolumeContainer {
        val builtJavaResource =
            com.pulumi.azurenative.storsimple.VolumeContainer(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return VolumeContainer(builtJavaResource)
    }
}

/**
 * The volume container.
 * Azure REST API version: 2017-06-01. Prior API version in Azure Native 1.x: 2017-06-01.
 * ## Example Usage
 * ### VolumeContainersCreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var volumeContainer = new AzureNative.StorSimple.VolumeContainer("volumeContainer", new()
 *     {
 *         BandwidthSettingId = "/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/bandwidthSettings/bandwidthSetting1",
 *         DeviceName = "Device05ForSDKTest",
 *         EncryptionKey = new AzureNative.StorSimple.Inputs.AsymmetricEncryptedSecretArgs
 *         {
 *             EncryptionAlgorithm = AzureNative.StorSimple.EncryptionAlgorithm.RSAES_PKCS1_v_1_5,
 *             EncryptionCertThumbprint = "A872A2DF196AC7682EE24791E7DE2E2A360F5926",
 *             Value = "R//pyVLx/fn58ia098JiLgZB5RY7fVT+6o8a4fmsvjy+ls2UgJphMf25XVqEQCZnsp/5uxteN1M/9ArPIICdhM7M1+b/Ur7kJ0FH0ktxfk7CrPWWJLI4q20LZoduJGI56lREav1VpuLdqw5F9fRcq7zbfgPQ3B/SD0mfumNRiV+AnwbC6msfavIuWrhVDl9iSzEPE+zU06/kpsexnrS81yYT2QlVVUbvpY4F3zfH8TQPpAROTbv2pld6JO4eGOrZ5O1iOr6XCg2TY2W/jf+Ev4z5tqC9VWXE5kh65gjBfpWN0bDWXKekqEhor2crHAxZi4dybdY8Ok1MDWd1CSU8kw==",
 *         },
 *         ManagerName = "ManagerForSDKTest1",
 *         ResourceGroupName = "ResourceGroupForSDKTest",
 *         StorageAccountCredentialId = "/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/storageAccountCredentials/safortestrecording",
 *         VolumeContainerName = "VolumeContainerForSDKTest",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storsimple/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storsimple.NewVolumeContainer(ctx, "volumeContainer", &storsimple.VolumeContainerArgs{
 * 			BandwidthSettingId: pulumi.String("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/bandwidthSettings/bandwidthSetting1"),
 * 			DeviceName:         pulumi.String("Device05ForSDKTest"),
 * 			EncryptionKey: &storsimple.AsymmetricEncryptedSecretArgs{
 * 				EncryptionAlgorithm:      storsimple.EncryptionAlgorithm_RSAES_PKCS1_v_1_5,
 * 				EncryptionCertThumbprint: pulumi.String("A872A2DF196AC7682EE24791E7DE2E2A360F5926"),
 * 				Value:                    pulumi.String("R//pyVLx/fn58ia098JiLgZB5RY7fVT+6o8a4fmsvjy+ls2UgJphMf25XVqEQCZnsp/5uxteN1M/9ArPIICdhM7M1+b/Ur7kJ0FH0ktxfk7CrPWWJLI4q20LZoduJGI56lREav1VpuLdqw5F9fRcq7zbfgPQ3B/SD0mfumNRiV+AnwbC6msfavIuWrhVDl9iSzEPE+zU06/kpsexnrS81yYT2QlVVUbvpY4F3zfH8TQPpAROTbv2pld6JO4eGOrZ5O1iOr6XCg2TY2W/jf+Ev4z5tqC9VWXE5kh65gjBfpWN0bDWXKekqEhor2crHAxZi4dybdY8Ok1MDWd1CSU8kw=="),
 * 			},
 * 			ManagerName:                pulumi.String("ManagerForSDKTest1"),
 * 			ResourceGroupName:          pulumi.String("ResourceGroupForSDKTest"),
 * 			StorageAccountCredentialId: pulumi.String("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/storageAccountCredentials/safortestrecording"),
 * 			VolumeContainerName:        pulumi.String("VolumeContainerForSDKTest"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storsimple.VolumeContainer;
 * import com.pulumi.azurenative.storsimple.VolumeContainerArgs;
 * import com.pulumi.azurenative.storsimple.inputs.AsymmetricEncryptedSecretArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var volumeContainer = new VolumeContainer("volumeContainer", VolumeContainerArgs.builder()
 *             .bandwidthSettingId("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/bandwidthSettings/bandwidthSetting1")
 *             .deviceName("Device05ForSDKTest")
 *             .encryptionKey(AsymmetricEncryptedSecretArgs.builder()
 *                 .encryptionAlgorithm("RSAES_PKCS1_v_1_5")
 *                 .encryptionCertThumbprint("A872A2DF196AC7682EE24791E7DE2E2A360F5926")
 *                 .value("R//pyVLx/fn58ia098JiLgZB5RY7fVT+6o8a4fmsvjy+ls2UgJphMf25XVqEQCZnsp/5uxteN1M/9ArPIICdhM7M1+b/Ur7kJ0FH0ktxfk7CrPWWJLI4q20LZoduJGI56lREav1VpuLdqw5F9fRcq7zbfgPQ3B/SD0mfumNRiV+AnwbC6msfavIuWrhVDl9iSzEPE+zU06/kpsexnrS81yYT2QlVVUbvpY4F3zfH8TQPpAROTbv2pld6JO4eGOrZ5O1iOr6XCg2TY2W/jf+Ev4z5tqC9VWXE5kh65gjBfpWN0bDWXKekqEhor2crHAxZi4dybdY8Ok1MDWd1CSU8kw==")
 *                 .build())
 *             .managerName("ManagerForSDKTest1")
 *             .resourceGroupName("ResourceGroupForSDKTest")
 *             .storageAccountCredentialId("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/storageAccountCredentials/safortestrecording")
 *             .volumeContainerName("VolumeContainerForSDKTest")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:storsimple:VolumeContainer VolumeContainerForSDKTest /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/volumeContainers/{volumeContainerName}
 * ```
 */
public class VolumeContainer internal constructor(
    override val javaResource: com.pulumi.azurenative.storsimple.VolumeContainer,
) : KotlinCustomResource(javaResource, VolumeContainerMapper) {
    /**
     * The bandwidth-rate set on the volume container.
     */
    public val bandWidthRateInMbps: Output<Int>?
        get() = javaResource.bandWidthRateInMbps().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the bandwidth setting associated with the volume container.
     */
    public val bandwidthSettingId: Output<String>?
        get() = javaResource.bandwidthSettingId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The key used to encrypt data in the volume container. It is required when property 'EncryptionStatus' is "Enabled".
     */
    public val encryptionKey: Output<AsymmetricEncryptedSecretResponse>?
        get() = javaResource.encryptionKey().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The flag to denote whether encryption is enabled or not.
     */
    public val encryptionStatus: Output<String>
        get() = javaResource.encryptionStatus().applyValue({ args0 -> args0 })

    /**
     * The Kind of the object. Currently only Series8000 is supported
     */
    public val kind: Output<String>?
        get() = javaResource.kind().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the object.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The owner ship status of the volume container. Only when the status is "NotOwned", the delete operation on the volume container is permitted.
     */
    public val ownerShipStatus: Output<String>
        get() = javaResource.ownerShipStatus().applyValue({ args0 -> args0 })

    /**
     * The path ID of storage account associated with the volume container.
     */
    public val storageAccountCredentialId: Output<String>
        get() = javaResource.storageAccountCredentialId().applyValue({ args0 -> args0 })

    /**
     * The total cloud storage for the volume container.
     */
    public val totalCloudStorageUsageInBytes: Output<Double>
        get() = javaResource.totalCloudStorageUsageInBytes().applyValue({ args0 -> args0 })

    /**
     * The hierarchical type of the object.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The number of volumes in the volume Container.
     */
    public val volumeCount: Output<Int>
        get() = javaResource.volumeCount().applyValue({ args0 -> args0 })
}

public object VolumeContainerMapper : ResourceMapper<VolumeContainer> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.storsimple.VolumeContainer::class == javaResource::class

    override fun map(javaResource: Resource): VolumeContainer = VolumeContainer(
        javaResource as
            com.pulumi.azurenative.storsimple.VolumeContainer,
    )
}

/**
 * @see [VolumeContainer].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VolumeContainer].
 */
public suspend fun volumeContainer(
    name: String,
    block: suspend VolumeContainerResourceBuilder.() -> Unit,
): VolumeContainer {
    val builder = VolumeContainerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VolumeContainer].
 * @param name The _unique_ name of the resulting resource.
 */
public fun volumeContainer(name: String): VolumeContainer {
    val builder = VolumeContainerResourceBuilder()
    builder.name(name)
    return builder.build()
}
