@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storsimple.kotlin.inputs

import com.pulumi.azurenative.storsimple.inputs.ListDeviceFailoverSetsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property deviceName The device name
 * @property managerName The manager name
 * @property resourceGroupName The resource group name
 */
public data class ListDeviceFailoverSetsPlainArgs(
    public val deviceName: String,
    public val managerName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.storsimple.inputs.ListDeviceFailoverSetsPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.storsimple.inputs.ListDeviceFailoverSetsPlainArgs =
        com.pulumi.azurenative.storsimple.inputs.ListDeviceFailoverSetsPlainArgs.builder()
            .deviceName(deviceName.let({ args0 -> args0 }))
            .managerName(managerName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListDeviceFailoverSetsPlainArgs].
 */
@PulumiTagMarker
public class ListDeviceFailoverSetsPlainArgsBuilder internal constructor() {
    private var deviceName: String? = null

    private var managerName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The device name
     */
    @JvmName("iedpmffoidlrksjm")
    public suspend fun deviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.deviceName = mapped
    }

    /**
     * @param value The manager name
     */
    @JvmName("beampkcrbocfufdj")
    public suspend fun managerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.managerName = mapped
    }

    /**
     * @param value The resource group name
     */
    @JvmName("psqphbekiggkckau")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): ListDeviceFailoverSetsPlainArgs = ListDeviceFailoverSetsPlainArgs(
        deviceName = deviceName ?: throw PulumiNullFieldException("deviceName"),
        managerName = managerName ?: throw PulumiNullFieldException("managerName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
