@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storsimple.kotlin.inputs

import com.pulumi.azurenative.storsimple.inputs.ListDeviceFailoverTarsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property managerName The manager name
 * @property resourceGroupName The resource group name
 * @property sourceDeviceName The source device name on which failover is performed.
 * @property volumeContainers The list of path IDs of the volume containers that needs to be failed-over, for which we want to fetch the eligible targets.
 */
public data class ListDeviceFailoverTarsPlainArgs(
    public val managerName: String,
    public val resourceGroupName: String,
    public val sourceDeviceName: String,
    public val volumeContainers: List<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storsimple.inputs.ListDeviceFailoverTarsPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.storsimple.inputs.ListDeviceFailoverTarsPlainArgs =
        com.pulumi.azurenative.storsimple.inputs.ListDeviceFailoverTarsPlainArgs.builder()
            .managerName(managerName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .sourceDeviceName(sourceDeviceName.let({ args0 -> args0 }))
            .volumeContainers(volumeContainers?.let({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ListDeviceFailoverTarsPlainArgs].
 */
@PulumiTagMarker
public class ListDeviceFailoverTarsPlainArgsBuilder internal constructor() {
    private var managerName: String? = null

    private var resourceGroupName: String? = null

    private var sourceDeviceName: String? = null

    private var volumeContainers: List<String>? = null

    /**
     * @param value The manager name
     */
    @JvmName("ueqaeuvmgogkxgnf")
    public suspend fun managerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.managerName = mapped
    }

    /**
     * @param value The resource group name
     */
    @JvmName("rbmkpjhyhtwvgsci")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The source device name on which failover is performed.
     */
    @JvmName("ygdunmsjtixavnpa")
    public suspend fun sourceDeviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.sourceDeviceName = mapped
    }

    /**
     * @param value The list of path IDs of the volume containers that needs to be failed-over, for which we want to fetch the eligible targets.
     */
    @JvmName("slnixmtbyatbwovm")
    public suspend fun volumeContainers(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.volumeContainers = mapped
    }

    /**
     * @param values The list of path IDs of the volume containers that needs to be failed-over, for which we want to fetch the eligible targets.
     */
    @JvmName("kbogwddujgxxilai")
    public suspend fun volumeContainers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.volumeContainers = mapped
    }

    internal fun build(): ListDeviceFailoverTarsPlainArgs = ListDeviceFailoverTarsPlainArgs(
        managerName = managerName ?: throw PulumiNullFieldException("managerName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        sourceDeviceName = sourceDeviceName ?: throw PulumiNullFieldException("sourceDeviceName"),
        volumeContainers = volumeContainers,
    )
}
