@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storsimple.kotlin.inputs

import com.pulumi.azurenative.storsimple.inputs.ScheduleRecurrenceArgs.builder
import com.pulumi.azurenative.storsimple.kotlin.enums.DayOfWeek
import com.pulumi.azurenative.storsimple.kotlin.enums.RecurrenceType
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The schedule recurrence.
 * @property recurrenceType The recurrence type.
 * @property recurrenceValue The recurrence value.
 * @property weeklyDaysList The week days list. Applicable only for schedules of recurrence type 'weekly'.
 */
public data class ScheduleRecurrenceArgs(
    public val recurrenceType: Output<RecurrenceType>,
    public val recurrenceValue: Output<Int>,
    public val weeklyDaysList: Output<List<DayOfWeek>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storsimple.inputs.ScheduleRecurrenceArgs> {
    override fun toJava(): com.pulumi.azurenative.storsimple.inputs.ScheduleRecurrenceArgs =
        com.pulumi.azurenative.storsimple.inputs.ScheduleRecurrenceArgs.builder()
            .recurrenceType(recurrenceType.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .recurrenceValue(recurrenceValue.applyValue({ args0 -> args0 }))
            .weeklyDaysList(
                weeklyDaysList?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ScheduleRecurrenceArgs].
 */
@PulumiTagMarker
public class ScheduleRecurrenceArgsBuilder internal constructor() {
    private var recurrenceType: Output<RecurrenceType>? = null

    private var recurrenceValue: Output<Int>? = null

    private var weeklyDaysList: Output<List<DayOfWeek>>? = null

    /**
     * @param value The recurrence type.
     */
    @JvmName("elmnuufsinfmycby")
    public suspend fun recurrenceType(`value`: Output<RecurrenceType>) {
        this.recurrenceType = value
    }

    /**
     * @param value The recurrence value.
     */
    @JvmName("quycktlqxemsvxmx")
    public suspend fun recurrenceValue(`value`: Output<Int>) {
        this.recurrenceValue = value
    }

    /**
     * @param value The week days list. Applicable only for schedules of recurrence type 'weekly'.
     */
    @JvmName("qdvdpfaukeinrvkr")
    public suspend fun weeklyDaysList(`value`: Output<List<DayOfWeek>>) {
        this.weeklyDaysList = value
    }

    @JvmName("gsavkileqlkiugvy")
    public suspend fun weeklyDaysList(vararg values: Output<DayOfWeek>) {
        this.weeklyDaysList = Output.all(values.asList())
    }

    /**
     * @param values The week days list. Applicable only for schedules of recurrence type 'weekly'.
     */
    @JvmName("yuvkpbwctyjwvsec")
    public suspend fun weeklyDaysList(values: List<Output<DayOfWeek>>) {
        this.weeklyDaysList = Output.all(values)
    }

    /**
     * @param value The recurrence type.
     */
    @JvmName("qimkpnrktcovjbfx")
    public suspend fun recurrenceType(`value`: RecurrenceType) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.recurrenceType = mapped
    }

    /**
     * @param value The recurrence value.
     */
    @JvmName("ckvjbiktnurwuoyf")
    public suspend fun recurrenceValue(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.recurrenceValue = mapped
    }

    /**
     * @param value The week days list. Applicable only for schedules of recurrence type 'weekly'.
     */
    @JvmName("tdsrkttmjiivebgu")
    public suspend fun weeklyDaysList(`value`: List<DayOfWeek>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.weeklyDaysList = mapped
    }

    /**
     * @param values The week days list. Applicable only for schedules of recurrence type 'weekly'.
     */
    @JvmName("jvsffxftvfevfcya")
    public suspend fun weeklyDaysList(vararg values: DayOfWeek) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.weeklyDaysList = mapped
    }

    internal fun build(): ScheduleRecurrenceArgs = ScheduleRecurrenceArgs(
        recurrenceType = recurrenceType ?: throw PulumiNullFieldException("recurrenceType"),
        recurrenceValue = recurrenceValue ?: throw PulumiNullFieldException("recurrenceValue"),
        weeklyDaysList = weeklyDaysList,
    )
}
