@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storsimple.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The schedule recurrence.
 * @property recurrenceType The recurrence type.
 * @property recurrenceValue The recurrence value.
 * @property weeklyDaysList The week days list. Applicable only for schedules of recurrence type 'weekly'.
 */
public data class ScheduleRecurrenceResponse(
    public val recurrenceType: String,
    public val recurrenceValue: Int,
    public val weeklyDaysList: List<String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.storsimple.outputs.ScheduleRecurrenceResponse):
            ScheduleRecurrenceResponse = ScheduleRecurrenceResponse(
            recurrenceType = javaType.recurrenceType(),
            recurrenceValue = javaType.recurrenceValue(),
            weeklyDaysList = javaType.weeklyDaysList().map({ args0 -> args0 }),
        )
    }
}
