@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Valid values are JobStorageAccount and SystemAccount. If set to JobStorageAccount, this requires the user to also specify jobStorageAccount property. .
 */
public enum class ContentStoragePolicy(
    public val javaValue: com.pulumi.azurenative.streamanalytics.enums.ContentStoragePolicy,
) : ConvertibleToJava<com.pulumi.azurenative.streamanalytics.enums.ContentStoragePolicy> {
    SystemAccount(com.pulumi.azurenative.streamanalytics.enums.ContentStoragePolicy.SystemAccount),
    JobStorageAccount(com.pulumi.azurenative.streamanalytics.enums.ContentStoragePolicy.JobStorageAccount),
    ;

    override fun toJava(): com.pulumi.azurenative.streamanalytics.enums.ContentStoragePolicy =
        javaValue

    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.streamanalytics.enums.ContentStoragePolicy):
            ContentStoragePolicy = ContentStoragePolicy.values().first { it.javaValue == javaType }
    }
}
