@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin.inputs

import com.pulumi.azurenative.streamanalytics.inputs.AzureSqlDatabaseOutputDataSourceArgs.builder
import com.pulumi.azurenative.streamanalytics.kotlin.enums.AuthenticationMode
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes an Azure SQL database output data source.
 * @property authenticationMode Authentication Mode.
 * @property database The name of the Azure SQL database. Required on PUT (CreateOrReplace) requests.
 * @property maxBatchCount Max Batch count for write to Sql database, the default value is 10,000. Optional on PUT requests.
 * @property maxWriterCount Max Writer count, currently only 1(single writer) and 0(based on query partition) are available. Optional on PUT requests.
 * @property password The password that will be used to connect to the Azure SQL database. Required on PUT (CreateOrReplace) requests.
 * @property server The name of the SQL server containing the Azure SQL database. Required on PUT (CreateOrReplace) requests.
 * @property table The name of the table in the Azure SQL database. Required on PUT (CreateOrReplace) requests.
 * @property type Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
 * Expected value is 'Microsoft.Sql/Server/Database'.
 * @property user The user name that will be used to connect to the Azure SQL database. Required on PUT (CreateOrReplace) requests.
 */
public data class AzureSqlDatabaseOutputDataSourceArgs(
    public val authenticationMode: Output<Either<String, AuthenticationMode>>? = null,
    public val database: Output<String>? = null,
    public val maxBatchCount: Output<Double>? = null,
    public val maxWriterCount: Output<Double>? = null,
    public val password: Output<String>? = null,
    public val server: Output<String>? = null,
    public val table: Output<String>? = null,
    public val type: Output<String>,
    public val user: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.streamanalytics.inputs.AzureSqlDatabaseOutputDataSourceArgs> {
    override fun toJava():
        com.pulumi.azurenative.streamanalytics.inputs.AzureSqlDatabaseOutputDataSourceArgs =
        com.pulumi.azurenative.streamanalytics.inputs.AzureSqlDatabaseOutputDataSourceArgs.builder()
            .authenticationMode(
                authenticationMode?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .database(database?.applyValue({ args0 -> args0 }))
            .maxBatchCount(maxBatchCount?.applyValue({ args0 -> args0 }))
            .maxWriterCount(maxWriterCount?.applyValue({ args0 -> args0 }))
            .password(password?.applyValue({ args0 -> args0 }))
            .server(server?.applyValue({ args0 -> args0 }))
            .table(table?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 }))
            .user(user?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzureSqlDatabaseOutputDataSourceArgs].
 */
@PulumiTagMarker
public class AzureSqlDatabaseOutputDataSourceArgsBuilder internal constructor() {
    private var authenticationMode: Output<Either<String, AuthenticationMode>>? = null

    private var database: Output<String>? = null

    private var maxBatchCount: Output<Double>? = null

    private var maxWriterCount: Output<Double>? = null

    private var password: Output<String>? = null

    private var server: Output<String>? = null

    private var table: Output<String>? = null

    private var type: Output<String>? = null

    private var user: Output<String>? = null

    /**
     * @param value Authentication Mode.
     */
    @JvmName("aebqrtqxiaieqldo")
    public suspend fun authenticationMode(`value`: Output<Either<String, AuthenticationMode>>) {
        this.authenticationMode = value
    }

    /**
     * @param value The name of the Azure SQL database. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("ykolbtbdnktquymt")
    public suspend fun database(`value`: Output<String>) {
        this.database = value
    }

    /**
     * @param value Max Batch count for write to Sql database, the default value is 10,000. Optional on PUT requests.
     */
    @JvmName("fkmhjfgfkamdiglg")
    public suspend fun maxBatchCount(`value`: Output<Double>) {
        this.maxBatchCount = value
    }

    /**
     * @param value Max Writer count, currently only 1(single writer) and 0(based on query partition) are available. Optional on PUT requests.
     */
    @JvmName("ijnddjafarprtwjb")
    public suspend fun maxWriterCount(`value`: Output<Double>) {
        this.maxWriterCount = value
    }

    /**
     * @param value The password that will be used to connect to the Azure SQL database. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("qcaqgjpmlvyqraxp")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value The name of the SQL server containing the Azure SQL database. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("kpyjwdafjlcsqsap")
    public suspend fun server(`value`: Output<String>) {
        this.server = value
    }

    /**
     * @param value The name of the table in the Azure SQL database. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("aonsmsjpdesdrkqa")
    public suspend fun table(`value`: Output<String>) {
        this.table = value
    }

    /**
     * @param value Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
     * Expected value is 'Microsoft.Sql/Server/Database'.
     */
    @JvmName("loclxnlglslbqrmk")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The user name that will be used to connect to the Azure SQL database. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("oldaxbclqxyuqnwj")
    public suspend fun user(`value`: Output<String>) {
        this.user = value
    }

    /**
     * @param value Authentication Mode.
     */
    @JvmName("dcwjikbblpttjhvq")
    public suspend fun authenticationMode(`value`: Either<String, AuthenticationMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authenticationMode = mapped
    }

    /**
     * @param value Authentication Mode.
     */
    @JvmName("hkfhmawtbcthjtqq")
    public fun authenticationMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AuthenticationMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationMode = mapped
    }

    /**
     * @param value Authentication Mode.
     */
    @JvmName("imsdxvqabxpvascu")
    public fun authenticationMode(`value`: AuthenticationMode) {
        val toBeMapped = Either.ofRight<String, AuthenticationMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationMode = mapped
    }

    /**
     * @param value The name of the Azure SQL database. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("kpcxekdesxpqywxa")
    public suspend fun database(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.database = mapped
    }

    /**
     * @param value Max Batch count for write to Sql database, the default value is 10,000. Optional on PUT requests.
     */
    @JvmName("enrciiesojhulhpg")
    public suspend fun maxBatchCount(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxBatchCount = mapped
    }

    /**
     * @param value Max Writer count, currently only 1(single writer) and 0(based on query partition) are available. Optional on PUT requests.
     */
    @JvmName("jwwueycfheikssxn")
    public suspend fun maxWriterCount(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxWriterCount = mapped
    }

    /**
     * @param value The password that will be used to connect to the Azure SQL database. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("ijgockhdbouvjghd")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value The name of the SQL server containing the Azure SQL database. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("hncxrteqxrfmlikg")
    public suspend fun server(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.server = mapped
    }

    /**
     * @param value The name of the table in the Azure SQL database. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("nqdquthguhuujyxb")
    public suspend fun table(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.table = mapped
    }

    /**
     * @param value Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
     * Expected value is 'Microsoft.Sql/Server/Database'.
     */
    @JvmName("bttdyekumdjtvtlp")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The user name that will be used to connect to the Azure SQL database. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("ivvaengejkeydewq")
    public suspend fun user(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.user = mapped
    }

    internal fun build(): AzureSqlDatabaseOutputDataSourceArgs = AzureSqlDatabaseOutputDataSourceArgs(
        authenticationMode = authenticationMode,
        database = database,
        maxBatchCount = maxBatchCount,
        maxWriterCount = maxWriterCount,
        password = password,
        server = server,
        table = table,
        type = type ?: throw PulumiNullFieldException("type"),
        user = user,
    )
}
