@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin.inputs

import com.pulumi.azurenative.streamanalytics.inputs.BlobOutputDataSourceArgs.builder
import com.pulumi.azurenative.streamanalytics.kotlin.enums.AuthenticationMode
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Describes a blob output data source.
 * @property authenticationMode Authentication Mode.
 * @property blobPathPrefix Blob path prefix.
 * @property container The name of a container within the associated Storage account. This container contains either the blob(s) to be read from or written to. Required on PUT (CreateOrReplace) requests.
 * @property dateFormat The date format. Wherever {date} appears in pathPattern, the value of this property is used as the date format instead.
 * @property pathPattern The blob path pattern. Not a regular expression. It represents a pattern against which blob names will be matched to determine whether or not they should be included as input or output to the job. See https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-input or https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-output for a more detailed explanation and example.
 * @property storageAccounts A list of one or more Azure Storage accounts. Required on PUT (CreateOrReplace) requests.
 * @property timeFormat The time format. Wherever {time} appears in pathPattern, the value of this property is used as the time format instead.
 * @property type Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
 * Expected value is 'Microsoft.Storage/Blob'.
 */
public data class BlobOutputDataSourceArgs(
    public val authenticationMode: Output<Either<String, AuthenticationMode>>? = null,
    public val blobPathPrefix: Output<String>? = null,
    public val container: Output<String>? = null,
    public val dateFormat: Output<String>? = null,
    public val pathPattern: Output<String>? = null,
    public val storageAccounts: Output<List<StorageAccountArgs>>? = null,
    public val timeFormat: Output<String>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.streamanalytics.inputs.BlobOutputDataSourceArgs> {
    override fun toJava(): com.pulumi.azurenative.streamanalytics.inputs.BlobOutputDataSourceArgs =
        com.pulumi.azurenative.streamanalytics.inputs.BlobOutputDataSourceArgs.builder()
            .authenticationMode(
                authenticationMode?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .blobPathPrefix(blobPathPrefix?.applyValue({ args0 -> args0 }))
            .container(container?.applyValue({ args0 -> args0 }))
            .dateFormat(dateFormat?.applyValue({ args0 -> args0 }))
            .pathPattern(pathPattern?.applyValue({ args0 -> args0 }))
            .storageAccounts(
                storageAccounts?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .timeFormat(timeFormat?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BlobOutputDataSourceArgs].
 */
@PulumiTagMarker
public class BlobOutputDataSourceArgsBuilder internal constructor() {
    private var authenticationMode: Output<Either<String, AuthenticationMode>>? = null

    private var blobPathPrefix: Output<String>? = null

    private var container: Output<String>? = null

    private var dateFormat: Output<String>? = null

    private var pathPattern: Output<String>? = null

    private var storageAccounts: Output<List<StorageAccountArgs>>? = null

    private var timeFormat: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value Authentication Mode.
     */
    @JvmName("ertajqylodmfwaly")
    public suspend fun authenticationMode(`value`: Output<Either<String, AuthenticationMode>>) {
        this.authenticationMode = value
    }

    /**
     * @param value Blob path prefix.
     */
    @JvmName("gohndoitjdbxhgif")
    public suspend fun blobPathPrefix(`value`: Output<String>) {
        this.blobPathPrefix = value
    }

    /**
     * @param value The name of a container within the associated Storage account. This container contains either the blob(s) to be read from or written to. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("boaoavcskjhnhafh")
    public suspend fun container(`value`: Output<String>) {
        this.container = value
    }

    /**
     * @param value The date format. Wherever {date} appears in pathPattern, the value of this property is used as the date format instead.
     */
    @JvmName("sirkjuxyoppiqmlt")
    public suspend fun dateFormat(`value`: Output<String>) {
        this.dateFormat = value
    }

    /**
     * @param value The blob path pattern. Not a regular expression. It represents a pattern against which blob names will be matched to determine whether or not they should be included as input or output to the job. See https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-input or https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-output for a more detailed explanation and example.
     */
    @JvmName("qtgisvchlgcqesrd")
    public suspend fun pathPattern(`value`: Output<String>) {
        this.pathPattern = value
    }

    /**
     * @param value A list of one or more Azure Storage accounts. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("cfkhtrniryfothcc")
    public suspend fun storageAccounts(`value`: Output<List<StorageAccountArgs>>) {
        this.storageAccounts = value
    }

    @JvmName("gcwyttvelwkfhlkf")
    public suspend fun storageAccounts(vararg values: Output<StorageAccountArgs>) {
        this.storageAccounts = Output.all(values.asList())
    }

    /**
     * @param values A list of one or more Azure Storage accounts. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("pwvdshcjpymhgrop")
    public suspend fun storageAccounts(values: List<Output<StorageAccountArgs>>) {
        this.storageAccounts = Output.all(values)
    }

    /**
     * @param value The time format. Wherever {time} appears in pathPattern, the value of this property is used as the time format instead.
     */
    @JvmName("agjdcbpgwedtkxts")
    public suspend fun timeFormat(`value`: Output<String>) {
        this.timeFormat = value
    }

    /**
     * @param value Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
     * Expected value is 'Microsoft.Storage/Blob'.
     */
    @JvmName("qqykswgesfabnfym")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Authentication Mode.
     */
    @JvmName("yogolyhduchuubvw")
    public suspend fun authenticationMode(`value`: Either<String, AuthenticationMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authenticationMode = mapped
    }

    /**
     * @param value Authentication Mode.
     */
    @JvmName("aumgxqtbuopbiaas")
    public fun authenticationMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AuthenticationMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationMode = mapped
    }

    /**
     * @param value Authentication Mode.
     */
    @JvmName("djaplheueleqvegp")
    public fun authenticationMode(`value`: AuthenticationMode) {
        val toBeMapped = Either.ofRight<String, AuthenticationMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationMode = mapped
    }

    /**
     * @param value Blob path prefix.
     */
    @JvmName("inyfheeyrkyfooyy")
    public suspend fun blobPathPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.blobPathPrefix = mapped
    }

    /**
     * @param value The name of a container within the associated Storage account. This container contains either the blob(s) to be read from or written to. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("arysanaogntefkqv")
    public suspend fun container(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.container = mapped
    }

    /**
     * @param value The date format. Wherever {date} appears in pathPattern, the value of this property is used as the date format instead.
     */
    @JvmName("wwdfcropyeyryawu")
    public suspend fun dateFormat(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dateFormat = mapped
    }

    /**
     * @param value The blob path pattern. Not a regular expression. It represents a pattern against which blob names will be matched to determine whether or not they should be included as input or output to the job. See https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-input or https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-output for a more detailed explanation and example.
     */
    @JvmName("xcsskbavuimbyxbh")
    public suspend fun pathPattern(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pathPattern = mapped
    }

    /**
     * @param value A list of one or more Azure Storage accounts. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("iwxgqdcurmmtqlpf")
    public suspend fun storageAccounts(`value`: List<StorageAccountArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccounts = mapped
    }

    /**
     * @param argument A list of one or more Azure Storage accounts. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("sejmitpmdauouxtm")
    public suspend fun storageAccounts(argument: List<suspend StorageAccountArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            StorageAccountArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.storageAccounts = mapped
    }

    /**
     * @param argument A list of one or more Azure Storage accounts. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("plbhutlldhgwkmdd")
    public suspend fun storageAccounts(
        vararg
        argument: suspend StorageAccountArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            StorageAccountArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.storageAccounts = mapped
    }

    /**
     * @param argument A list of one or more Azure Storage accounts. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("ifjeotbulhltqvpb")
    public suspend fun storageAccounts(argument: suspend StorageAccountArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(StorageAccountArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.storageAccounts = mapped
    }

    /**
     * @param values A list of one or more Azure Storage accounts. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("shjuswnbqogtbvle")
    public suspend fun storageAccounts(vararg values: StorageAccountArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storageAccounts = mapped
    }

    /**
     * @param value The time format. Wherever {time} appears in pathPattern, the value of this property is used as the time format instead.
     */
    @JvmName("hkyopoknqilerolr")
    public suspend fun timeFormat(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeFormat = mapped
    }

    /**
     * @param value Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
     * Expected value is 'Microsoft.Storage/Blob'.
     */
    @JvmName("yluwafjjldfaytik")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): BlobOutputDataSourceArgs = BlobOutputDataSourceArgs(
        authenticationMode = authenticationMode,
        blobPathPrefix = blobPathPrefix,
        container = container,
        dateFormat = dateFormat,
        pathPattern = pathPattern,
        storageAccounts = storageAccounts,
        timeFormat = timeFormat,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
