@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin.inputs

import com.pulumi.azurenative.streamanalytics.inputs.BlobStreamInputDataSourceArgs.builder
import com.pulumi.azurenative.streamanalytics.kotlin.enums.AuthenticationMode
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Describes a blob input data source that contains stream data.
 * @property authenticationMode Authentication Mode.
 * @property container The name of a container within the associated Storage account. This container contains either the blob(s) to be read from or written to. Required on PUT (CreateOrReplace) requests.
 * @property dateFormat The date format. Wherever {date} appears in pathPattern, the value of this property is used as the date format instead.
 * @property pathPattern The blob path pattern. Not a regular expression. It represents a pattern against which blob names will be matched to determine whether or not they should be included as input or output to the job. See https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-input or https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-output for a more detailed explanation and example.
 * @property sourcePartitionCount The partition count of the blob input data source. Range 1 - 1024.
 * @property storageAccounts A list of one or more Azure Storage accounts. Required on PUT (CreateOrReplace) requests.
 * @property timeFormat The time format. Wherever {time} appears in pathPattern, the value of this property is used as the time format instead.
 * @property type Indicates the type of input data source containing stream data. Required on PUT (CreateOrReplace) requests.
 * Expected value is 'Microsoft.Storage/Blob'.
 */
public data class BlobStreamInputDataSourceArgs(
    public val authenticationMode: Output<Either<String, AuthenticationMode>>? = null,
    public val container: Output<String>? = null,
    public val dateFormat: Output<String>? = null,
    public val pathPattern: Output<String>? = null,
    public val sourcePartitionCount: Output<Int>? = null,
    public val storageAccounts: Output<List<StorageAccountArgs>>? = null,
    public val timeFormat: Output<String>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.streamanalytics.inputs.BlobStreamInputDataSourceArgs> {
    override fun toJava(): com.pulumi.azurenative.streamanalytics.inputs.BlobStreamInputDataSourceArgs =
        com.pulumi.azurenative.streamanalytics.inputs.BlobStreamInputDataSourceArgs.builder()
            .authenticationMode(
                authenticationMode?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .container(container?.applyValue({ args0 -> args0 }))
            .dateFormat(dateFormat?.applyValue({ args0 -> args0 }))
            .pathPattern(pathPattern?.applyValue({ args0 -> args0 }))
            .sourcePartitionCount(sourcePartitionCount?.applyValue({ args0 -> args0 }))
            .storageAccounts(
                storageAccounts?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .timeFormat(timeFormat?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BlobStreamInputDataSourceArgs].
 */
@PulumiTagMarker
public class BlobStreamInputDataSourceArgsBuilder internal constructor() {
    private var authenticationMode: Output<Either<String, AuthenticationMode>>? = null

    private var container: Output<String>? = null

    private var dateFormat: Output<String>? = null

    private var pathPattern: Output<String>? = null

    private var sourcePartitionCount: Output<Int>? = null

    private var storageAccounts: Output<List<StorageAccountArgs>>? = null

    private var timeFormat: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value Authentication Mode.
     */
    @JvmName("cybryoqjhvkqomoq")
    public suspend fun authenticationMode(`value`: Output<Either<String, AuthenticationMode>>) {
        this.authenticationMode = value
    }

    /**
     * @param value The name of a container within the associated Storage account. This container contains either the blob(s) to be read from or written to. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("posydqpenrgytlea")
    public suspend fun container(`value`: Output<String>) {
        this.container = value
    }

    /**
     * @param value The date format. Wherever {date} appears in pathPattern, the value of this property is used as the date format instead.
     */
    @JvmName("wwitfmraxirqykso")
    public suspend fun dateFormat(`value`: Output<String>) {
        this.dateFormat = value
    }

    /**
     * @param value The blob path pattern. Not a regular expression. It represents a pattern against which blob names will be matched to determine whether or not they should be included as input or output to the job. See https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-input or https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-output for a more detailed explanation and example.
     */
    @JvmName("xiafudjxepbadwjo")
    public suspend fun pathPattern(`value`: Output<String>) {
        this.pathPattern = value
    }

    /**
     * @param value The partition count of the blob input data source. Range 1 - 1024.
     */
    @JvmName("duwjfvfnvyjpgrwp")
    public suspend fun sourcePartitionCount(`value`: Output<Int>) {
        this.sourcePartitionCount = value
    }

    /**
     * @param value A list of one or more Azure Storage accounts. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("eaajekooaiighvqj")
    public suspend fun storageAccounts(`value`: Output<List<StorageAccountArgs>>) {
        this.storageAccounts = value
    }

    @JvmName("llpiudvdeyspjvxp")
    public suspend fun storageAccounts(vararg values: Output<StorageAccountArgs>) {
        this.storageAccounts = Output.all(values.asList())
    }

    /**
     * @param values A list of one or more Azure Storage accounts. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("beahjbwlkafnivjb")
    public suspend fun storageAccounts(values: List<Output<StorageAccountArgs>>) {
        this.storageAccounts = Output.all(values)
    }

    /**
     * @param value The time format. Wherever {time} appears in pathPattern, the value of this property is used as the time format instead.
     */
    @JvmName("vjknpofsyiovchxm")
    public suspend fun timeFormat(`value`: Output<String>) {
        this.timeFormat = value
    }

    /**
     * @param value Indicates the type of input data source containing stream data. Required on PUT (CreateOrReplace) requests.
     * Expected value is 'Microsoft.Storage/Blob'.
     */
    @JvmName("jnyxjntygjxrmlsr")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Authentication Mode.
     */
    @JvmName("ghmthcjitkrtomdn")
    public suspend fun authenticationMode(`value`: Either<String, AuthenticationMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authenticationMode = mapped
    }

    /**
     * @param value Authentication Mode.
     */
    @JvmName("cbyuufdacbgqjxra")
    public fun authenticationMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AuthenticationMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationMode = mapped
    }

    /**
     * @param value Authentication Mode.
     */
    @JvmName("twvyovnyhuyitfbc")
    public fun authenticationMode(`value`: AuthenticationMode) {
        val toBeMapped = Either.ofRight<String, AuthenticationMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationMode = mapped
    }

    /**
     * @param value The name of a container within the associated Storage account. This container contains either the blob(s) to be read from or written to. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("bgmqysaxtjmgujci")
    public suspend fun container(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.container = mapped
    }

    /**
     * @param value The date format. Wherever {date} appears in pathPattern, the value of this property is used as the date format instead.
     */
    @JvmName("nyftqacnrjakabgp")
    public suspend fun dateFormat(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dateFormat = mapped
    }

    /**
     * @param value The blob path pattern. Not a regular expression. It represents a pattern against which blob names will be matched to determine whether or not they should be included as input or output to the job. See https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-input or https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-output for a more detailed explanation and example.
     */
    @JvmName("plvsywnnmpsnywkj")
    public suspend fun pathPattern(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pathPattern = mapped
    }

    /**
     * @param value The partition count of the blob input data source. Range 1 - 1024.
     */
    @JvmName("wgomnngyqodesxgt")
    public suspend fun sourcePartitionCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourcePartitionCount = mapped
    }

    /**
     * @param value A list of one or more Azure Storage accounts. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("rfxtypkywddibddx")
    public suspend fun storageAccounts(`value`: List<StorageAccountArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccounts = mapped
    }

    /**
     * @param argument A list of one or more Azure Storage accounts. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("vyhuscycasgexqvb")
    public suspend fun storageAccounts(argument: List<suspend StorageAccountArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            StorageAccountArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.storageAccounts = mapped
    }

    /**
     * @param argument A list of one or more Azure Storage accounts. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("atgjhkdhulkrqcjy")
    public suspend fun storageAccounts(
        vararg
        argument: suspend StorageAccountArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            StorageAccountArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.storageAccounts = mapped
    }

    /**
     * @param argument A list of one or more Azure Storage accounts. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("imwoccawsmbmlpid")
    public suspend fun storageAccounts(argument: suspend StorageAccountArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(StorageAccountArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.storageAccounts = mapped
    }

    /**
     * @param values A list of one or more Azure Storage accounts. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("ocopkwfenxosytuf")
    public suspend fun storageAccounts(vararg values: StorageAccountArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storageAccounts = mapped
    }

    /**
     * @param value The time format. Wherever {time} appears in pathPattern, the value of this property is used as the time format instead.
     */
    @JvmName("pkccpeohksiyhddx")
    public suspend fun timeFormat(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeFormat = mapped
    }

    /**
     * @param value Indicates the type of input data source containing stream data. Required on PUT (CreateOrReplace) requests.
     * Expected value is 'Microsoft.Storage/Blob'.
     */
    @JvmName("oebwequtcekhjrhu")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): BlobStreamInputDataSourceArgs = BlobStreamInputDataSourceArgs(
        authenticationMode = authenticationMode,
        container = container,
        dateFormat = dateFormat,
        pathPattern = pathPattern,
        sourcePartitionCount = sourcePartitionCount,
        storageAccounts = storageAccounts,
        timeFormat = timeFormat,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
