@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin.inputs

import com.pulumi.azurenative.streamanalytics.inputs.CompressionArgs.builder
import com.pulumi.azurenative.streamanalytics.kotlin.enums.CompressionType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes how input data is compressed
 * @property type Indicates the type of compression that the input uses. Required on PUT (CreateOrReplace) requests.
 */
public data class CompressionArgs(
    public val type: Output<Either<String, CompressionType>>,
) : ConvertibleToJava<com.pulumi.azurenative.streamanalytics.inputs.CompressionArgs> {
    override fun toJava(): com.pulumi.azurenative.streamanalytics.inputs.CompressionArgs =
        com.pulumi.azurenative.streamanalytics.inputs.CompressionArgs.builder()
            .type(
                type.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [CompressionArgs].
 */
@PulumiTagMarker
public class CompressionArgsBuilder internal constructor() {
    private var type: Output<Either<String, CompressionType>>? = null

    /**
     * @param value Indicates the type of compression that the input uses. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("kxdfrltqmsnijmjx")
    public suspend fun type(`value`: Output<Either<String, CompressionType>>) {
        this.type = value
    }

    /**
     * @param value Indicates the type of compression that the input uses. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("jocqkrxxosxbxdac")
    public suspend fun type(`value`: Either<String, CompressionType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Indicates the type of compression that the input uses. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("yvwenlmukgkabtuk")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, CompressionType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Indicates the type of compression that the input uses. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("efijahelexsiwnur")
    public fun type(`value`: CompressionType) {
        val toBeMapped = Either.ofRight<String, CompressionType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): CompressionArgs = CompressionArgs(
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
