@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin.inputs

import com.pulumi.azurenative.streamanalytics.inputs.EventHubV2OutputDataSourceArgs.builder
import com.pulumi.azurenative.streamanalytics.kotlin.enums.AuthenticationMode
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Describes an Event Hub output data source.
 * @property authenticationMode Authentication Mode.
 * @property eventHubName The name of the Event Hub. Required on PUT (CreateOrReplace) requests.
 * @property partitionKey The key/column that is used to determine to which partition to send event data.
 * @property propertyColumns The properties associated with this Event Hub output.
 * @property serviceBusNamespace The namespace that is associated with the desired Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
 * @property sharedAccessPolicyKey The shared access policy key for the specified shared access policy. Required on PUT (CreateOrReplace) requests.
 * @property sharedAccessPolicyName The shared access policy name for the Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
 * @property type Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
 * Expected value is 'Microsoft.EventHub/EventHub'.
 */
public data class EventHubV2OutputDataSourceArgs(
    public val authenticationMode: Output<Either<String, AuthenticationMode>>? = null,
    public val eventHubName: Output<String>? = null,
    public val partitionKey: Output<String>? = null,
    public val propertyColumns: Output<List<String>>? = null,
    public val serviceBusNamespace: Output<String>? = null,
    public val sharedAccessPolicyKey: Output<String>? = null,
    public val sharedAccessPolicyName: Output<String>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.streamanalytics.inputs.EventHubV2OutputDataSourceArgs> {
    override fun toJava():
        com.pulumi.azurenative.streamanalytics.inputs.EventHubV2OutputDataSourceArgs =
        com.pulumi.azurenative.streamanalytics.inputs.EventHubV2OutputDataSourceArgs.builder()
            .authenticationMode(
                authenticationMode?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .eventHubName(eventHubName?.applyValue({ args0 -> args0 }))
            .partitionKey(partitionKey?.applyValue({ args0 -> args0 }))
            .propertyColumns(propertyColumns?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .serviceBusNamespace(serviceBusNamespace?.applyValue({ args0 -> args0 }))
            .sharedAccessPolicyKey(sharedAccessPolicyKey?.applyValue({ args0 -> args0 }))
            .sharedAccessPolicyName(sharedAccessPolicyName?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EventHubV2OutputDataSourceArgs].
 */
@PulumiTagMarker
public class EventHubV2OutputDataSourceArgsBuilder internal constructor() {
    private var authenticationMode: Output<Either<String, AuthenticationMode>>? = null

    private var eventHubName: Output<String>? = null

    private var partitionKey: Output<String>? = null

    private var propertyColumns: Output<List<String>>? = null

    private var serviceBusNamespace: Output<String>? = null

    private var sharedAccessPolicyKey: Output<String>? = null

    private var sharedAccessPolicyName: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value Authentication Mode.
     */
    @JvmName("yvnqpasrgieradye")
    public suspend fun authenticationMode(`value`: Output<Either<String, AuthenticationMode>>) {
        this.authenticationMode = value
    }

    /**
     * @param value The name of the Event Hub. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("crwonxfcivksxjvv")
    public suspend fun eventHubName(`value`: Output<String>) {
        this.eventHubName = value
    }

    /**
     * @param value The key/column that is used to determine to which partition to send event data.
     */
    @JvmName("kmqrsbctlbkmpfua")
    public suspend fun partitionKey(`value`: Output<String>) {
        this.partitionKey = value
    }

    /**
     * @param value The properties associated with this Event Hub output.
     */
    @JvmName("jeffqxwmstgktsaa")
    public suspend fun propertyColumns(`value`: Output<List<String>>) {
        this.propertyColumns = value
    }

    @JvmName("lkoljcpnqqmmskmb")
    public suspend fun propertyColumns(vararg values: Output<String>) {
        this.propertyColumns = Output.all(values.asList())
    }

    /**
     * @param values The properties associated with this Event Hub output.
     */
    @JvmName("mviocsbndsouydba")
    public suspend fun propertyColumns(values: List<Output<String>>) {
        this.propertyColumns = Output.all(values)
    }

    /**
     * @param value The namespace that is associated with the desired Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("eljkppvjxabifhtf")
    public suspend fun serviceBusNamespace(`value`: Output<String>) {
        this.serviceBusNamespace = value
    }

    /**
     * @param value The shared access policy key for the specified shared access policy. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("syrdkhdvjhtxdnod")
    public suspend fun sharedAccessPolicyKey(`value`: Output<String>) {
        this.sharedAccessPolicyKey = value
    }

    /**
     * @param value The shared access policy name for the Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("lxltnnrykqridhho")
    public suspend fun sharedAccessPolicyName(`value`: Output<String>) {
        this.sharedAccessPolicyName = value
    }

    /**
     * @param value Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
     * Expected value is 'Microsoft.EventHub/EventHub'.
     */
    @JvmName("ljbcvvtlqgkxdahl")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Authentication Mode.
     */
    @JvmName("hbxobsmgsihmegyl")
    public suspend fun authenticationMode(`value`: Either<String, AuthenticationMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authenticationMode = mapped
    }

    /**
     * @param value Authentication Mode.
     */
    @JvmName("rsxyvccjpxasofde")
    public fun authenticationMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AuthenticationMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationMode = mapped
    }

    /**
     * @param value Authentication Mode.
     */
    @JvmName("sftnkguyekgqhmsw")
    public fun authenticationMode(`value`: AuthenticationMode) {
        val toBeMapped = Either.ofRight<String, AuthenticationMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationMode = mapped
    }

    /**
     * @param value The name of the Event Hub. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("okvhhqrgiatvjoej")
    public suspend fun eventHubName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventHubName = mapped
    }

    /**
     * @param value The key/column that is used to determine to which partition to send event data.
     */
    @JvmName("okcdyffyoxwqnfxj")
    public suspend fun partitionKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partitionKey = mapped
    }

    /**
     * @param value The properties associated with this Event Hub output.
     */
    @JvmName("xydtcucqickeqjsl")
    public suspend fun propertyColumns(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.propertyColumns = mapped
    }

    /**
     * @param values The properties associated with this Event Hub output.
     */
    @JvmName("yvtgcsnhyqbduxay")
    public suspend fun propertyColumns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.propertyColumns = mapped
    }

    /**
     * @param value The namespace that is associated with the desired Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("lhspgifbekkunbah")
    public suspend fun serviceBusNamespace(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceBusNamespace = mapped
    }

    /**
     * @param value The shared access policy key for the specified shared access policy. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("gcsiofwwinlxqhdx")
    public suspend fun sharedAccessPolicyKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sharedAccessPolicyKey = mapped
    }

    /**
     * @param value The shared access policy name for the Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("lmqvmkklmkiogyyy")
    public suspend fun sharedAccessPolicyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sharedAccessPolicyName = mapped
    }

    /**
     * @param value Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
     * Expected value is 'Microsoft.EventHub/EventHub'.
     */
    @JvmName("otlclqemxnioakaq")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): EventHubV2OutputDataSourceArgs = EventHubV2OutputDataSourceArgs(
        authenticationMode = authenticationMode,
        eventHubName = eventHubName,
        partitionKey = partitionKey,
        propertyColumns = propertyColumns,
        serviceBusNamespace = serviceBusNamespace,
        sharedAccessPolicyKey = sharedAccessPolicyKey,
        sharedAccessPolicyName = sharedAccessPolicyName,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
