@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin.inputs

import com.pulumi.azurenative.streamanalytics.inputs.GatewayMessageBusStreamInputDataSourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes a blob input data source that contains stream data.
 * @property topic The name of the Service Bus topic.
 * @property type Indicates the type of input data source containing stream data. Required on PUT (CreateOrReplace) requests.
 * Expected value is 'GatewayMessageBus'.
 */
public data class GatewayMessageBusStreamInputDataSourceArgs(
    public val topic: Output<String>? = null,
    public val type: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.streamanalytics.inputs.GatewayMessageBusStreamInputDataSourceArgs> {
    override fun toJava():
        com.pulumi.azurenative.streamanalytics.inputs.GatewayMessageBusStreamInputDataSourceArgs =
        com.pulumi.azurenative.streamanalytics.inputs.GatewayMessageBusStreamInputDataSourceArgs.builder()
            .topic(topic?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GatewayMessageBusStreamInputDataSourceArgs].
 */
@PulumiTagMarker
public class GatewayMessageBusStreamInputDataSourceArgsBuilder internal constructor() {
    private var topic: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value The name of the Service Bus topic.
     */
    @JvmName("kifgbeacvlkshtxd")
    public suspend fun topic(`value`: Output<String>) {
        this.topic = value
    }

    /**
     * @param value Indicates the type of input data source containing stream data. Required on PUT (CreateOrReplace) requests.
     * Expected value is 'GatewayMessageBus'.
     */
    @JvmName("pkivdjbbufygfcnf")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The name of the Service Bus topic.
     */
    @JvmName("kxjcklhdmwivskdn")
    public suspend fun topic(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.topic = mapped
    }

    /**
     * @param value Indicates the type of input data source containing stream data. Required on PUT (CreateOrReplace) requests.
     * Expected value is 'GatewayMessageBus'.
     */
    @JvmName("nxptcvpargstxolc")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): GatewayMessageBusStreamInputDataSourceArgs =
        GatewayMessageBusStreamInputDataSourceArgs(
            topic = topic,
            type = type ?: throw PulumiNullFieldException("type"),
        )
}
