@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin.inputs

import com.pulumi.azurenative.streamanalytics.inputs.GetInputPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property inputName The name of the input.
 * @property jobName The name of the streaming job.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetInputPlainArgs(
    public val inputName: String,
    public val jobName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.streamanalytics.inputs.GetInputPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.streamanalytics.inputs.GetInputPlainArgs =
        com.pulumi.azurenative.streamanalytics.inputs.GetInputPlainArgs.builder()
            .inputName(inputName.let({ args0 -> args0 }))
            .jobName(jobName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetInputPlainArgs].
 */
@PulumiTagMarker
public class GetInputPlainArgsBuilder internal constructor() {
    private var inputName: String? = null

    private var jobName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the input.
     */
    @JvmName("whrqispnifnvxkrr")
    public suspend fun inputName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.inputName = mapped
    }

    /**
     * @param value The name of the streaming job.
     */
    @JvmName("hirqdbnlrvfxmcby")
    public suspend fun jobName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.jobName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ejsrmisaadcsrmaj")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetInputPlainArgs = GetInputPlainArgs(
        inputName = inputName ?: throw PulumiNullFieldException("inputName"),
        jobName = jobName ?: throw PulumiNullFieldException("jobName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
