@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin.inputs

import com.pulumi.azurenative.streamanalytics.inputs.PowerBIOutputDataSourceArgs.builder
import com.pulumi.azurenative.streamanalytics.kotlin.enums.AuthenticationMode
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes a Power BI output data source.
 * @property authenticationMode Authentication Mode.
 * @property dataset The name of the Power BI dataset. Required on PUT (CreateOrReplace) requests.
 * @property groupId The ID of the Power BI group.
 * @property groupName The name of the Power BI group. Use this property to help remember which specific Power BI group id was used.
 * @property refreshToken A refresh token that can be used to obtain a valid access token that can then be used to authenticate with the data source. A valid refresh token is currently only obtainable via the Azure Portal. It is recommended to put a dummy string value here when creating the data source and then going to the Azure Portal to authenticate the data source which will update this property with a valid refresh token. Required on PUT (CreateOrReplace) requests.
 * @property table The name of the Power BI table under the specified dataset. Required on PUT (CreateOrReplace) requests.
 * @property tokenUserDisplayName The user display name of the user that was used to obtain the refresh token. Use this property to help remember which user was used to obtain the refresh token.
 * @property tokenUserPrincipalName The user principal name (UPN) of the user that was used to obtain the refresh token. Use this property to help remember which user was used to obtain the refresh token.
 * @property type Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
 * Expected value is 'PowerBI'.
 */
public data class PowerBIOutputDataSourceArgs(
    public val authenticationMode: Output<Either<String, AuthenticationMode>>? = null,
    public val dataset: Output<String>? = null,
    public val groupId: Output<String>? = null,
    public val groupName: Output<String>? = null,
    public val refreshToken: Output<String>? = null,
    public val table: Output<String>? = null,
    public val tokenUserDisplayName: Output<String>? = null,
    public val tokenUserPrincipalName: Output<String>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.streamanalytics.inputs.PowerBIOutputDataSourceArgs> {
    override fun toJava(): com.pulumi.azurenative.streamanalytics.inputs.PowerBIOutputDataSourceArgs =
        com.pulumi.azurenative.streamanalytics.inputs.PowerBIOutputDataSourceArgs.builder()
            .authenticationMode(
                authenticationMode?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .dataset(dataset?.applyValue({ args0 -> args0 }))
            .groupId(groupId?.applyValue({ args0 -> args0 }))
            .groupName(groupName?.applyValue({ args0 -> args0 }))
            .refreshToken(refreshToken?.applyValue({ args0 -> args0 }))
            .table(table?.applyValue({ args0 -> args0 }))
            .tokenUserDisplayName(tokenUserDisplayName?.applyValue({ args0 -> args0 }))
            .tokenUserPrincipalName(tokenUserPrincipalName?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PowerBIOutputDataSourceArgs].
 */
@PulumiTagMarker
public class PowerBIOutputDataSourceArgsBuilder internal constructor() {
    private var authenticationMode: Output<Either<String, AuthenticationMode>>? = null

    private var dataset: Output<String>? = null

    private var groupId: Output<String>? = null

    private var groupName: Output<String>? = null

    private var refreshToken: Output<String>? = null

    private var table: Output<String>? = null

    private var tokenUserDisplayName: Output<String>? = null

    private var tokenUserPrincipalName: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value Authentication Mode.
     */
    @JvmName("oxixdrehamnydfoq")
    public suspend fun authenticationMode(`value`: Output<Either<String, AuthenticationMode>>) {
        this.authenticationMode = value
    }

    /**
     * @param value The name of the Power BI dataset. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("dtolnotqnuikcdav")
    public suspend fun dataset(`value`: Output<String>) {
        this.dataset = value
    }

    /**
     * @param value The ID of the Power BI group.
     */
    @JvmName("lvyvauemyiitefcy")
    public suspend fun groupId(`value`: Output<String>) {
        this.groupId = value
    }

    /**
     * @param value The name of the Power BI group. Use this property to help remember which specific Power BI group id was used.
     */
    @JvmName("xwwjbofiyhqkkicn")
    public suspend fun groupName(`value`: Output<String>) {
        this.groupName = value
    }

    /**
     * @param value A refresh token that can be used to obtain a valid access token that can then be used to authenticate with the data source. A valid refresh token is currently only obtainable via the Azure Portal. It is recommended to put a dummy string value here when creating the data source and then going to the Azure Portal to authenticate the data source which will update this property with a valid refresh token. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("baqcbxtdchfhfcvs")
    public suspend fun refreshToken(`value`: Output<String>) {
        this.refreshToken = value
    }

    /**
     * @param value The name of the Power BI table under the specified dataset. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("livqlkuuqyrktvka")
    public suspend fun table(`value`: Output<String>) {
        this.table = value
    }

    /**
     * @param value The user display name of the user that was used to obtain the refresh token. Use this property to help remember which user was used to obtain the refresh token.
     */
    @JvmName("rcbpnnilqydwsbsh")
    public suspend fun tokenUserDisplayName(`value`: Output<String>) {
        this.tokenUserDisplayName = value
    }

    /**
     * @param value The user principal name (UPN) of the user that was used to obtain the refresh token. Use this property to help remember which user was used to obtain the refresh token.
     */
    @JvmName("npqqylbbssbgejjg")
    public suspend fun tokenUserPrincipalName(`value`: Output<String>) {
        this.tokenUserPrincipalName = value
    }

    /**
     * @param value Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
     * Expected value is 'PowerBI'.
     */
    @JvmName("tvmkfvahfurbiomm")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Authentication Mode.
     */
    @JvmName("aovopqqvnsdxeiss")
    public suspend fun authenticationMode(`value`: Either<String, AuthenticationMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authenticationMode = mapped
    }

    /**
     * @param value Authentication Mode.
     */
    @JvmName("kcnnpteuuirrpxkq")
    public fun authenticationMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AuthenticationMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationMode = mapped
    }

    /**
     * @param value Authentication Mode.
     */
    @JvmName("cbakuctqqiteivvb")
    public fun authenticationMode(`value`: AuthenticationMode) {
        val toBeMapped = Either.ofRight<String, AuthenticationMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationMode = mapped
    }

    /**
     * @param value The name of the Power BI dataset. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("fuqyamafkvotdgcg")
    public suspend fun dataset(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataset = mapped
    }

    /**
     * @param value The ID of the Power BI group.
     */
    @JvmName("lauhxyhxbqpmqvjs")
    public suspend fun groupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupId = mapped
    }

    /**
     * @param value The name of the Power BI group. Use this property to help remember which specific Power BI group id was used.
     */
    @JvmName("odfohdxuxkluwbvl")
    public suspend fun groupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupName = mapped
    }

    /**
     * @param value A refresh token that can be used to obtain a valid access token that can then be used to authenticate with the data source. A valid refresh token is currently only obtainable via the Azure Portal. It is recommended to put a dummy string value here when creating the data source and then going to the Azure Portal to authenticate the data source which will update this property with a valid refresh token. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("yiqtxndtmauacpsu")
    public suspend fun refreshToken(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.refreshToken = mapped
    }

    /**
     * @param value The name of the Power BI table under the specified dataset. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("qxrdnjnfkcdyqmaf")
    public suspend fun table(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.table = mapped
    }

    /**
     * @param value The user display name of the user that was used to obtain the refresh token. Use this property to help remember which user was used to obtain the refresh token.
     */
    @JvmName("bbcgoleuvfnipfgp")
    public suspend fun tokenUserDisplayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tokenUserDisplayName = mapped
    }

    /**
     * @param value The user principal name (UPN) of the user that was used to obtain the refresh token. Use this property to help remember which user was used to obtain the refresh token.
     */
    @JvmName("cpsmvfprwxbrxavv")
    public suspend fun tokenUserPrincipalName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tokenUserPrincipalName = mapped
    }

    /**
     * @param value Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
     * Expected value is 'PowerBI'.
     */
    @JvmName("smhjvksunbrpibjh")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): PowerBIOutputDataSourceArgs = PowerBIOutputDataSourceArgs(
        authenticationMode = authenticationMode,
        dataset = dataset,
        groupId = groupId,
        groupName = groupName,
        refreshToken = refreshToken,
        table = table,
        tokenUserDisplayName = tokenUserDisplayName,
        tokenUserPrincipalName = tokenUserPrincipalName,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
