@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin.inputs

import com.pulumi.azurenative.streamanalytics.inputs.StorageAccountArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The properties that are associated with an Azure Storage account
 * @property accountKey The account key for the Azure Storage account. Required on PUT (CreateOrReplace) requests.
 * @property accountName The name of the Azure Storage account. Required on PUT (CreateOrReplace) requests.
 */
public data class StorageAccountArgs(
    public val accountKey: Output<String>? = null,
    public val accountName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.streamanalytics.inputs.StorageAccountArgs> {
    override fun toJava(): com.pulumi.azurenative.streamanalytics.inputs.StorageAccountArgs =
        com.pulumi.azurenative.streamanalytics.inputs.StorageAccountArgs.builder()
            .accountKey(accountKey?.applyValue({ args0 -> args0 }))
            .accountName(accountName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StorageAccountArgs].
 */
@PulumiTagMarker
public class StorageAccountArgsBuilder internal constructor() {
    private var accountKey: Output<String>? = null

    private var accountName: Output<String>? = null

    /**
     * @param value The account key for the Azure Storage account. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("pyhiyelxbtdwmacr")
    public suspend fun accountKey(`value`: Output<String>) {
        this.accountKey = value
    }

    /**
     * @param value The name of the Azure Storage account. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("ycswjknmhwplhluy")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value The account key for the Azure Storage account. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("vtcufjomashvpmao")
    public suspend fun accountKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountKey = mapped
    }

    /**
     * @param value The name of the Azure Storage account. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("gpgonjuppfigtycs")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    internal fun build(): StorageAccountArgs = StorageAccountArgs(
        accountKey = accountKey,
        accountName = accountName,
    )
}
