@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The binding to an Azure Machine Learning web service.
 * @property apiKey The API key used to authenticate with Request-Response endpoint.
 * @property batchSize Number between 1 and 10000 describing maximum number of rows for every Azure ML RRS execute request. Default is 1000.
 * @property endpoint The Request-Response execute endpoint of the Azure Machine Learning web service. Find out more here: https://docs.microsoft.com/en-us/azure/machine-learning/machine-learning-consume-web-services#request-response-service-rrs
 * @property inputs The inputs for the Azure Machine Learning web service endpoint.
 * @property outputs A list of outputs from the Azure Machine Learning web service endpoint execution.
 * @property type Indicates the function binding type.
 * Expected value is 'Microsoft.MachineLearning/WebService'.
 */
public data class AzureMachineLearningWebServiceFunctionBindingResponse(
    public val apiKey: String? = null,
    public val batchSize: Int? = null,
    public val endpoint: String? = null,
    public val inputs: AzureMachineLearningWebServiceInputsResponse? = null,
    public val outputs: List<AzureMachineLearningWebServiceOutputColumnResponse>? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.streamanalytics.outputs.AzureMachineLearningWebServiceFunctionBindingResponse):
            AzureMachineLearningWebServiceFunctionBindingResponse =
            AzureMachineLearningWebServiceFunctionBindingResponse(
                apiKey = javaType.apiKey().map({ args0 -> args0 }).orElse(null),
                batchSize = javaType.batchSize().map({ args0 -> args0 }).orElse(null),
                endpoint = javaType.endpoint().map({ args0 -> args0 }).orElse(null),
                inputs = javaType.inputs().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.streamanalytics.kotlin.outputs.AzureMachineLearningWebServiceInputsResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                outputs = javaType.outputs().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.streamanalytics.kotlin.outputs.AzureMachineLearningWebServiceOutputColumnResponse.Companion.toKotlin(args0)
                    })
                }),
                type = javaType.type(),
            )
    }
}
