@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes an output column for the Azure Machine Learning web service endpoint.
 * @property dataType The (Azure Machine Learning supported) data type of the output column. A list of valid  Azure Machine Learning data types are described at https://msdn.microsoft.com/en-us/library/azure/dn905923.aspx .
 * @property name The name of the output column.
 */
public data class AzureMachineLearningWebServiceOutputColumnResponse(
    public val dataType: String? = null,
    public val name: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.streamanalytics.outputs.AzureMachineLearningWebServiceOutputColumnResponse):
            AzureMachineLearningWebServiceOutputColumnResponse =
            AzureMachineLearningWebServiceOutputColumnResponse(
                dataType = javaType.dataType().map({ args0 -> args0 }).orElse(null),
                name = javaType.name().map({ args0 -> args0 }).orElse(null),
            )
    }
}
