@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes an Azure SQL database reference input data source.
 * @property database This element is associated with the datasource element. This is the name of the database that output will be written to.
 * @property deltaSnapshotQuery This element is associated with the datasource element. This query is used to fetch incremental changes from the SQL database. To use this option, we recommend using temporal tables in Azure SQL Database.
 * @property fullSnapshotQuery This element is associated with the datasource element. This query is used to fetch data from the sql database.
 * @property password This element is associated with the datasource element. This is the password that will be used to connect to the SQL Database instance.
 * @property refreshRate This element is associated with the datasource element. This indicates how frequently the data will be fetched from the database. It is of DateTime format.
 * @property refreshType Indicates the type of data refresh option.
 * @property server This element is associated with the datasource element. This is the name of the server that contains the database that will be written to.
 * @property table This element is associated with the datasource element. The name of the table in the Azure SQL database..
 * @property type Indicates the type of input data source containing reference data. Required on PUT (CreateOrReplace) requests.
 * Expected value is 'Microsoft.Sql/Server/Database'.
 * @property user This element is associated with the datasource element. This is the user name that will be used to connect to the SQL Database instance.
 */
public data class AzureSqlReferenceInputDataSourceResponse(
    public val database: String? = null,
    public val deltaSnapshotQuery: String? = null,
    public val fullSnapshotQuery: String? = null,
    public val password: String? = null,
    public val refreshRate: String? = null,
    public val refreshType: String? = null,
    public val server: String? = null,
    public val table: String? = null,
    public val type: String,
    public val user: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.streamanalytics.outputs.AzureSqlReferenceInputDataSourceResponse):
            AzureSqlReferenceInputDataSourceResponse = AzureSqlReferenceInputDataSourceResponse(
            database = javaType.database().map({ args0 -> args0 }).orElse(null),
            deltaSnapshotQuery = javaType.deltaSnapshotQuery().map({ args0 -> args0 }).orElse(null),
            fullSnapshotQuery = javaType.fullSnapshotQuery().map({ args0 -> args0 }).orElse(null),
            password = javaType.password().map({ args0 -> args0 }).orElse(null),
            refreshRate = javaType.refreshRate().map({ args0 -> args0 }).orElse(null),
            refreshType = javaType.refreshType().map({ args0 -> args0 }).orElse(null),
            server = javaType.server().map({ args0 -> args0 }).orElse(null),
            table = javaType.table().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            user = javaType.user().map({ args0 -> args0 }).orElse(null),
        )
    }
}
