@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Describes an Azure Table output data source.
 * @property accountKey The account key for the Azure Storage account. Required on PUT (CreateOrReplace) requests.
 * @property accountName The name of the Azure Storage account. Required on PUT (CreateOrReplace) requests.
 * @property batchSize The number of rows to write to the Azure Table at a time.
 * @property columnsToRemove If specified, each item in the array is the name of a column to remove (if present) from output event entities.
 * @property partitionKey This element indicates the name of a column from the SELECT statement in the query that will be used as the partition key for the Azure Table. Required on PUT (CreateOrReplace) requests.
 * @property rowKey This element indicates the name of a column from the SELECT statement in the query that will be used as the row key for the Azure Table. Required on PUT (CreateOrReplace) requests.
 * @property table The name of the Azure Table. Required on PUT (CreateOrReplace) requests.
 * @property type Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
 * Expected value is 'Microsoft.Storage/Table'.
 */
public data class AzureTableOutputDataSourceResponse(
    public val accountKey: String? = null,
    public val accountName: String? = null,
    public val batchSize: Int? = null,
    public val columnsToRemove: List<String>? = null,
    public val partitionKey: String? = null,
    public val rowKey: String? = null,
    public val table: String? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.streamanalytics.outputs.AzureTableOutputDataSourceResponse):
            AzureTableOutputDataSourceResponse = AzureTableOutputDataSourceResponse(
            accountKey = javaType.accountKey().map({ args0 -> args0 }).orElse(null),
            accountName = javaType.accountName().map({ args0 -> args0 }).orElse(null),
            batchSize = javaType.batchSize().map({ args0 -> args0 }).orElse(null),
            columnsToRemove = javaType.columnsToRemove().map({ args0 -> args0 }),
            partitionKey = javaType.partitionKey().map({ args0 -> args0 }).orElse(null),
            rowKey = javaType.rowKey().map({ args0 -> args0 }).orElse(null),
            table = javaType.table().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
