@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * A streaming job.
 * @property id Resource ID of the streaming job.
 * @property jobState The current execution state of the streaming job.
 * @property streamingUnits The number of streaming units that are used by the streaming job.
 */
public data class ClusterJobResponse(
    public val id: String,
    public val jobState: String,
    public val streamingUnits: Int,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.streamanalytics.outputs.ClusterJobResponse):
            ClusterJobResponse = ClusterJobResponse(
            id = javaType.id(),
            jobState = javaType.jobState(),
            streamingUnits = javaType.streamingUnits(),
        )
    }
}
