@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The properties that are associated with an Azure Storage account
 * @property accountKey The account key for the Azure Storage account. Required on PUT (CreateOrReplace) requests.
 * @property accountName The name of the Azure Storage account. Required on PUT (CreateOrReplace) requests.
 */
public data class StorageAccountResponse(
    public val accountKey: String? = null,
    public val accountName: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.streamanalytics.outputs.StorageAccountResponse):
            StorageAccountResponse = StorageAccountResponse(
            accountKey = javaType.accountKey().map({ args0 -> args0 }).orElse(null),
            accountName = javaType.accountName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
