@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.subscription.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The workload type of the subscription. It can be either Production or DevTest.
 */
public enum class Workload(
    public val javaValue: com.pulumi.azurenative.subscription.enums.Workload,
) : ConvertibleToJava<com.pulumi.azurenative.subscription.enums.Workload> {
    Production(com.pulumi.azurenative.subscription.enums.Workload.Production),
    DevTest(com.pulumi.azurenative.subscription.enums.Workload.DevTest),
    ;

    override fun toJava(): com.pulumi.azurenative.subscription.enums.Workload = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.subscription.enums.Workload): Workload =
            Workload.values().first { it.javaValue == javaType }
    }
}
