@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.subscription.kotlin.inputs

import com.pulumi.azurenative.subscription.inputs.GetAliasPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property aliasName AliasName is the name for the subscription creation request. Note that this is not the same as subscription name and this doesn’t have any other lifecycle need beyond the request for subscription creation.
 */
public data class GetAliasPlainArgs(
    public val aliasName: String,
) : ConvertibleToJava<com.pulumi.azurenative.subscription.inputs.GetAliasPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.subscription.inputs.GetAliasPlainArgs =
        com.pulumi.azurenative.subscription.inputs.GetAliasPlainArgs.builder()
            .aliasName(aliasName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAliasPlainArgs].
 */
@PulumiTagMarker
public class GetAliasPlainArgsBuilder internal constructor() {
    private var aliasName: String? = null

    /**
     * @param value AliasName is the name for the subscription creation request. Note that this is not the same as subscription name and this doesn’t have any other lifecycle need beyond the request for subscription creation.
     */
    @JvmName("hcjpsbuxfmbjkucq")
    public suspend fun aliasName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.aliasName = mapped
    }

    internal fun build(): GetAliasPlainArgs = GetAliasPlainArgs(
        aliasName = aliasName ?: throw PulumiNullFieldException("aliasName"),
    )
}
