@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.subscription.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Subscription Information with the alias.
 * @property id Fully qualified ID for the alias resource.
 * @property name Alias ID.
 * @property properties Subscription Alias response properties.
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property type Resource type, Microsoft.Subscription/aliases.
 */
public data class GetAliasResult(
    public val id: String,
    public val name: String,
    public val properties: SubscriptionAliasResponsePropertiesResponse,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.subscription.outputs.GetAliasResult):
            GetAliasResult = GetAliasResult(
            id = javaType.id(),
            name = javaType.name(),
            properties = javaType.properties().let({ args0 ->
                com.pulumi.azurenative.subscription.kotlin.outputs.SubscriptionAliasResponsePropertiesResponse.Companion.toKotlin(args0)
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.subscription.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
