@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin

import com.pulumi.azurenative.synapse.EventHubDataConnectionArgs.builder
import com.pulumi.azurenative.synapse.kotlin.enums.Compression
import com.pulumi.azurenative.synapse.kotlin.enums.EventHubDataFormat
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Class representing an event hub data connection.
 * Azure REST API version: 2021-06-01-preview.
 * ## Example Usage
 * ### KustoPoolDataConnectionsCreateOrUpdate.json
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var eventHubDataConnection = new AzureNative.Synapse.EventHubDataConnection("eventHubDataConnection", new()
 *     {
 *         ConsumerGroup = "testConsumerGroup1",
 *         DataConnectionName = "DataConnections8",
 *         DatabaseName = "KustoDatabase8",
 *         EventHubResourceId = "/subscriptions/12345678-1234-1234-1234-123456789098/resourceGroups/kustorptest/providers/Microsoft.EventHub/namespaces/eventhubTestns1/eventhubs/eventhubTest1",
 *         Kind = "EventHub",
 *         KustoPoolName = "kustoclusterrptest4",
 *         Location = "westus",
 *         ResourceGroupName = "kustorptest",
 *         WorkspaceName = "synapseWorkspaceName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/synapse/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := synapse.NewEventHubDataConnection(ctx, "eventHubDataConnection", &synapse.EventHubDataConnectionArgs{
 * 			ConsumerGroup:      pulumi.String("testConsumerGroup1"),
 * 			DataConnectionName: pulumi.String("DataConnections8"),
 * 			DatabaseName:       pulumi.String("KustoDatabase8"),
 * 			EventHubResourceId: pulumi.String("/subscriptions/12345678-1234-1234-1234-123456789098/resourceGroups/kustorptest/providers/Microsoft.EventHub/namespaces/eventhubTestns1/eventhubs/eventhubTest1"),
 * 			Kind:               pulumi.String("EventHub"),
 * 			KustoPoolName:      pulumi.String("kustoclusterrptest4"),
 * 			Location:           pulumi.String("westus"),
 * 			ResourceGroupName:  pulumi.String("kustorptest"),
 * 			WorkspaceName:      pulumi.String("synapseWorkspaceName"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.synapse.EventHubDataConnection;
 * import com.pulumi.azurenative.synapse.EventHubDataConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var eventHubDataConnection = new EventHubDataConnection("eventHubDataConnection", EventHubDataConnectionArgs.builder()
 *             .consumerGroup("testConsumerGroup1")
 *             .dataConnectionName("DataConnections8")
 *             .databaseName("KustoDatabase8")
 *             .eventHubResourceId("/subscriptions/12345678-1234-1234-1234-123456789098/resourceGroups/kustorptest/providers/Microsoft.EventHub/namespaces/eventhubTestns1/eventhubs/eventhubTest1")
 *             .kind("EventHub")
 *             .kustoPoolName("kustoclusterrptest4")
 *             .location("westus")
 *             .resourceGroupName("kustorptest")
 *             .workspaceName("synapseWorkspaceName")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:synapse:EventHubDataConnection KustoClusterRPTest4/KustoDatabase8/DataConnections8 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/kustoPools/{kustoPoolName}/databases/{databaseName}/dataConnections/{dataConnectionName}
 * ```
 * @property compression The event hub messages compression type
 * @property consumerGroup The event hub consumer group.
 * @property dataConnectionName The name of the data connection.
 * @property dataFormat The data format of the message. Optionally the data format can be added to each message.
 * @property databaseName The name of the database in the Kusto pool.
 * @property eventHubResourceId The resource ID of the event hub to be used to create a data connection.
 * @property eventSystemProperties System properties of the event hub
 * @property kind Kind of the endpoint for the data connection
 * Expected value is 'EventHub'.
 * @property kustoPoolName The name of the Kusto pool.
 * @property location Resource location.
 * @property managedIdentityResourceId The resource ID of a managed identity (system or user assigned) to be used to authenticate with event hub.
 * @property mappingRuleName The mapping rule to be used to ingest the data. Optionally the mapping information can be added to each message.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tableName The table where the data should be ingested. Optionally the table information can be added to each message.
 * @property workspaceName The name of the workspace.
 */
public data class EventHubDataConnectionArgs(
    public val compression: Output<Either<String, Compression>>? = null,
    public val consumerGroup: Output<String>? = null,
    public val dataConnectionName: Output<String>? = null,
    public val dataFormat: Output<Either<String, EventHubDataFormat>>? = null,
    public val databaseName: Output<String>? = null,
    public val eventHubResourceId: Output<String>? = null,
    public val eventSystemProperties: Output<List<String>>? = null,
    public val kind: Output<String>? = null,
    public val kustoPoolName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val managedIdentityResourceId: Output<String>? = null,
    public val mappingRuleName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tableName: Output<String>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.synapse.EventHubDataConnectionArgs> {
    override fun toJava(): com.pulumi.azurenative.synapse.EventHubDataConnectionArgs =
        com.pulumi.azurenative.synapse.EventHubDataConnectionArgs.builder()
            .compression(
                compression?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .consumerGroup(consumerGroup?.applyValue({ args0 -> args0 }))
            .dataConnectionName(dataConnectionName?.applyValue({ args0 -> args0 }))
            .dataFormat(
                dataFormat?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .databaseName(databaseName?.applyValue({ args0 -> args0 }))
            .eventHubResourceId(eventHubResourceId?.applyValue({ args0 -> args0 }))
            .eventSystemProperties(eventSystemProperties?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .kustoPoolName(kustoPoolName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .managedIdentityResourceId(managedIdentityResourceId?.applyValue({ args0 -> args0 }))
            .mappingRuleName(mappingRuleName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tableName(tableName?.applyValue({ args0 -> args0 }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EventHubDataConnectionArgs].
 */
@PulumiTagMarker
public class EventHubDataConnectionArgsBuilder internal constructor() {
    private var compression: Output<Either<String, Compression>>? = null

    private var consumerGroup: Output<String>? = null

    private var dataConnectionName: Output<String>? = null

    private var dataFormat: Output<Either<String, EventHubDataFormat>>? = null

    private var databaseName: Output<String>? = null

    private var eventHubResourceId: Output<String>? = null

    private var eventSystemProperties: Output<List<String>>? = null

    private var kind: Output<String>? = null

    private var kustoPoolName: Output<String>? = null

    private var location: Output<String>? = null

    private var managedIdentityResourceId: Output<String>? = null

    private var mappingRuleName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tableName: Output<String>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value The event hub messages compression type
     */
    @JvmName("vfukmavvjhufhfcn")
    public suspend fun compression(`value`: Output<Either<String, Compression>>) {
        this.compression = value
    }

    /**
     * @param value The event hub consumer group.
     */
    @JvmName("yayjvycyqqupuysi")
    public suspend fun consumerGroup(`value`: Output<String>) {
        this.consumerGroup = value
    }

    /**
     * @param value The name of the data connection.
     */
    @JvmName("ufsqbnjyyfawbcya")
    public suspend fun dataConnectionName(`value`: Output<String>) {
        this.dataConnectionName = value
    }

    /**
     * @param value The data format of the message. Optionally the data format can be added to each message.
     */
    @JvmName("yimbxnktipaekeex")
    public suspend fun dataFormat(`value`: Output<Either<String, EventHubDataFormat>>) {
        this.dataFormat = value
    }

    /**
     * @param value The name of the database in the Kusto pool.
     */
    @JvmName("tfkybeqlamyahipp")
    public suspend fun databaseName(`value`: Output<String>) {
        this.databaseName = value
    }

    /**
     * @param value The resource ID of the event hub to be used to create a data connection.
     */
    @JvmName("raaocsnxoxckisew")
    public suspend fun eventHubResourceId(`value`: Output<String>) {
        this.eventHubResourceId = value
    }

    /**
     * @param value System properties of the event hub
     */
    @JvmName("wqtwiqyuhwtwgess")
    public suspend fun eventSystemProperties(`value`: Output<List<String>>) {
        this.eventSystemProperties = value
    }

    @JvmName("jojbrcgcedgideiu")
    public suspend fun eventSystemProperties(vararg values: Output<String>) {
        this.eventSystemProperties = Output.all(values.asList())
    }

    /**
     * @param values System properties of the event hub
     */
    @JvmName("qfabjawxiuljgmxb")
    public suspend fun eventSystemProperties(values: List<Output<String>>) {
        this.eventSystemProperties = Output.all(values)
    }

    /**
     * @param value Kind of the endpoint for the data connection
     * Expected value is 'EventHub'.
     */
    @JvmName("jkynndkirjjvjrlw")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value The name of the Kusto pool.
     */
    @JvmName("wjhfjmxihjmaocqw")
    public suspend fun kustoPoolName(`value`: Output<String>) {
        this.kustoPoolName = value
    }

    /**
     * @param value Resource location.
     */
    @JvmName("pyrvgywjeaqdlbnw")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The resource ID of a managed identity (system or user assigned) to be used to authenticate with event hub.
     */
    @JvmName("hhmptsihhoukqjsp")
    public suspend fun managedIdentityResourceId(`value`: Output<String>) {
        this.managedIdentityResourceId = value
    }

    /**
     * @param value The mapping rule to be used to ingest the data. Optionally the mapping information can be added to each message.
     */
    @JvmName("lynpmhcggowibxvv")
    public suspend fun mappingRuleName(`value`: Output<String>) {
        this.mappingRuleName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("gngvylltcybrbgqb")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The table where the data should be ingested. Optionally the table information can be added to each message.
     */
    @JvmName("newxxqrjwiniotfq")
    public suspend fun tableName(`value`: Output<String>) {
        this.tableName = value
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("eugddmkyvhmrobjg")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value The event hub messages compression type
     */
    @JvmName("rbrrmghrwwsrkmys")
    public suspend fun compression(`value`: Either<String, Compression>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.compression = mapped
    }

    /**
     * @param value The event hub messages compression type
     */
    @JvmName("hilrrlyssadbqkos")
    public fun compression(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Compression>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.compression = mapped
    }

    /**
     * @param value The event hub messages compression type
     */
    @JvmName("emwcktyrrknptulw")
    public fun compression(`value`: Compression) {
        val toBeMapped = Either.ofRight<String, Compression>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.compression = mapped
    }

    /**
     * @param value The event hub consumer group.
     */
    @JvmName("eoulinxoktecpglu")
    public suspend fun consumerGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.consumerGroup = mapped
    }

    /**
     * @param value The name of the data connection.
     */
    @JvmName("smresevykgepuvxj")
    public suspend fun dataConnectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataConnectionName = mapped
    }

    /**
     * @param value The data format of the message. Optionally the data format can be added to each message.
     */
    @JvmName("begtsjplgudnbljg")
    public suspend fun dataFormat(`value`: Either<String, EventHubDataFormat>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataFormat = mapped
    }

    /**
     * @param value The data format of the message. Optionally the data format can be added to each message.
     */
    @JvmName("kpyhywhqxyrvncrl")
    public fun dataFormat(`value`: String) {
        val toBeMapped = Either.ofLeft<String, EventHubDataFormat>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataFormat = mapped
    }

    /**
     * @param value The data format of the message. Optionally the data format can be added to each message.
     */
    @JvmName("txjeqisfcivestbc")
    public fun dataFormat(`value`: EventHubDataFormat) {
        val toBeMapped = Either.ofRight<String, EventHubDataFormat>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataFormat = mapped
    }

    /**
     * @param value The name of the database in the Kusto pool.
     */
    @JvmName("dltrdydrsovqbtcd")
    public suspend fun databaseName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databaseName = mapped
    }

    /**
     * @param value The resource ID of the event hub to be used to create a data connection.
     */
    @JvmName("rvwndxyrvujutdfe")
    public suspend fun eventHubResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventHubResourceId = mapped
    }

    /**
     * @param value System properties of the event hub
     */
    @JvmName("gqhaqwukgchqcpvk")
    public suspend fun eventSystemProperties(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventSystemProperties = mapped
    }

    /**
     * @param values System properties of the event hub
     */
    @JvmName("nwmowdqljedgqpgy")
    public suspend fun eventSystemProperties(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.eventSystemProperties = mapped
    }

    /**
     * @param value Kind of the endpoint for the data connection
     * Expected value is 'EventHub'.
     */
    @JvmName("tugqiabgsamrujff")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The name of the Kusto pool.
     */
    @JvmName("soxabjpaxmxlogiy")
    public suspend fun kustoPoolName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kustoPoolName = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("lfuaqfrerpdcoocx")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The resource ID of a managed identity (system or user assigned) to be used to authenticate with event hub.
     */
    @JvmName("qbxqcmmowemmogtx")
    public suspend fun managedIdentityResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedIdentityResourceId = mapped
    }

    /**
     * @param value The mapping rule to be used to ingest the data. Optionally the mapping information can be added to each message.
     */
    @JvmName("qwkqsbxebrvdoinu")
    public suspend fun mappingRuleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mappingRuleName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("monmmafrlgyaplel")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The table where the data should be ingested. Optionally the table information can be added to each message.
     */
    @JvmName("vumykvltlynadjon")
    public suspend fun tableName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tableName = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("gsgeppqqrtytounr")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): EventHubDataConnectionArgs = EventHubDataConnectionArgs(
        compression = compression,
        consumerGroup = consumerGroup,
        dataConnectionName = dataConnectionName,
        dataFormat = dataFormat,
        databaseName = databaseName,
        eventHubResourceId = eventHubResourceId,
        eventSystemProperties = eventSystemProperties,
        kind = kind,
        kustoPoolName = kustoPoolName,
        location = location,
        managedIdentityResourceId = managedIdentityResourceId,
        mappingRuleName = mappingRuleName,
        resourceGroupName = resourceGroupName,
        tableName = tableName,
        workspaceName = workspaceName,
    )
}
