@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin

import com.pulumi.azurenative.synapse.kotlin.outputs.ManagedIntegrationRuntimeResponse
import com.pulumi.azurenative.synapse.kotlin.outputs.SelfHostedIntegrationRuntimeResponse
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [IntegrationRuntime].
 */
@PulumiTagMarker
public class IntegrationRuntimeResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: IntegrationRuntimeArgs = IntegrationRuntimeArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend IntegrationRuntimeArgsBuilder.() -> Unit) {
        val builder = IntegrationRuntimeArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): IntegrationRuntime {
        val builtJavaResource =
            com.pulumi.azurenative.synapse.IntegrationRuntime(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return IntegrationRuntime(builtJavaResource)
    }
}

/**
 * Integration runtime resource type.
 * Azure REST API version: 2021-06-01. Prior API version in Azure Native 1.x: 2021-03-01.
 * Other available API versions: 2021-06-01-preview.
 * ## Example Usage
 * ### Create integration runtime
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var integrationRuntime = new AzureNative.Synapse.IntegrationRuntime("integrationRuntime", new()
 *     {
 *         IntegrationRuntimeName = "exampleIntegrationRuntime",
 *         Properties = new AzureNative.Synapse.Inputs.SelfHostedIntegrationRuntimeArgs
 *         {
 *             Description = "A selfhosted integration runtime",
 *             Type = "SelfHosted",
 *         },
 *         ResourceGroupName = "exampleResourceGroup",
 *         WorkspaceName = "exampleWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/synapse/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := synapse.NewIntegrationRuntime(ctx, "integrationRuntime", &synapse.IntegrationRuntimeArgs{
 * 			IntegrationRuntimeName: pulumi.String("exampleIntegrationRuntime"),
 * 			Properties: synapse.SelfHostedIntegrationRuntime{
 * 				Description: "A selfhosted integration runtime",
 * 				Type:        "SelfHosted",
 * 			},
 * 			ResourceGroupName: pulumi.String("exampleResourceGroup"),
 * 			WorkspaceName:     pulumi.String("exampleWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.synapse.IntegrationRuntime;
 * import com.pulumi.azurenative.synapse.IntegrationRuntimeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var integrationRuntime = new IntegrationRuntime("integrationRuntime", IntegrationRuntimeArgs.builder()
 *             .integrationRuntimeName("exampleIntegrationRuntime")
 *             .properties(SelfHostedIntegrationRuntimeArgs.builder()
 *                 .description("A selfhosted integration runtime")
 *                 .type("SelfHosted")
 *                 .build())
 *             .resourceGroupName("exampleResourceGroup")
 *             .workspaceName("exampleWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:synapse:IntegrationRuntime exampleIntegrationRuntime /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/integrationRuntimes/{integrationRuntimeName}
 * ```
 */
public class IntegrationRuntime internal constructor(
    override val javaResource: com.pulumi.azurenative.synapse.IntegrationRuntime,
) : KotlinCustomResource(javaResource, IntegrationRuntimeMapper) {
    /**
     * Resource Etag.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Integration runtime properties.
     */
    public val properties:
        Output<Either<ManagedIntegrationRuntimeResponse, SelfHostedIntegrationRuntimeResponse>>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.transform(
                { args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.synapse.kotlin.outputs.ManagedIntegrationRuntimeResponse.Companion.toKotlin(args0)
                    })
                },
                { args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.synapse.kotlin.outputs.SelfHostedIntegrationRuntimeResponse.Companion.toKotlin(args0)
                    })
                },
            )
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object IntegrationRuntimeMapper : ResourceMapper<IntegrationRuntime> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.synapse.IntegrationRuntime::class == javaResource::class

    override fun map(javaResource: Resource): IntegrationRuntime = IntegrationRuntime(
        javaResource as
            com.pulumi.azurenative.synapse.IntegrationRuntime,
    )
}

/**
 * @see [IntegrationRuntime].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [IntegrationRuntime].
 */
public suspend fun integrationRuntime(
    name: String,
    block: suspend IntegrationRuntimeResourceBuilder.() -> Unit,
): IntegrationRuntime {
    val builder = IntegrationRuntimeResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [IntegrationRuntime].
 * @param name The _unique_ name of the resulting resource.
 */
public fun integrationRuntime(name: String): IntegrationRuntime {
    val builder = IntegrationRuntimeResourceBuilder()
    builder.name(name)
    return builder.build()
}
