@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin

import com.pulumi.azurenative.synapse.IotHubDataConnectionArgs.builder
import com.pulumi.azurenative.synapse.kotlin.enums.IotHubDataFormat
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Class representing an iot hub data connection.
 * Azure REST API version: 2021-06-01-preview.
 * ## Example Usage
 * ### KustoPoolDataConnectionsCreateOrUpdate.json
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var iotHubDataConnection = new AzureNative.Synapse.IotHubDataConnection("iotHubDataConnection", new()
 *     {
 *         DataConnectionName = "DataConnections8",
 *         DatabaseName = "KustoDatabase8",
 *         KustoPoolName = "kustoclusterrptest4",
 *         ResourceGroupName = "kustorptest",
 *         WorkspaceName = "synapseWorkspaceName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/synapse/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := synapse.NewIotHubDataConnection(ctx, "iotHubDataConnection", &synapse.IotHubDataConnectionArgs{
 * 			DataConnectionName: pulumi.String("DataConnections8"),
 * 			DatabaseName:       pulumi.String("KustoDatabase8"),
 * 			KustoPoolName:      pulumi.String("kustoclusterrptest4"),
 * 			ResourceGroupName:  pulumi.String("kustorptest"),
 * 			WorkspaceName:      pulumi.String("synapseWorkspaceName"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.synapse.IotHubDataConnection;
 * import com.pulumi.azurenative.synapse.IotHubDataConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var iotHubDataConnection = new IotHubDataConnection("iotHubDataConnection", IotHubDataConnectionArgs.builder()
 *             .dataConnectionName("DataConnections8")
 *             .databaseName("KustoDatabase8")
 *             .kustoPoolName("kustoclusterrptest4")
 *             .resourceGroupName("kustorptest")
 *             .workspaceName("synapseWorkspaceName")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:synapse:IotHubDataConnection KustoClusterRPTest4/KustoDatabase8/DataConnections8 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/kustoPools/{kustoPoolName}/databases/{databaseName}/dataConnections/{dataConnectionName}
 * ```
 * @property consumerGroup The iot hub consumer group.
 * @property dataConnectionName The name of the data connection.
 * @property dataFormat The data format of the message. Optionally the data format can be added to each message.
 * @property databaseName The name of the database in the Kusto pool.
 * @property eventSystemProperties System properties of the iot hub
 * @property iotHubResourceId The resource ID of the Iot hub to be used to create a data connection.
 * @property kind Kind of the endpoint for the data connection
 * Expected value is 'IotHub'.
 * @property kustoPoolName The name of the Kusto pool.
 * @property location Resource location.
 * @property mappingRuleName The mapping rule to be used to ingest the data. Optionally the mapping information can be added to each message.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property sharedAccessPolicyName The name of the share access policy
 * @property tableName The table where the data should be ingested. Optionally the table information can be added to each message.
 * @property workspaceName The name of the workspace.
 */
public data class IotHubDataConnectionArgs(
    public val consumerGroup: Output<String>? = null,
    public val dataConnectionName: Output<String>? = null,
    public val dataFormat: Output<Either<String, IotHubDataFormat>>? = null,
    public val databaseName: Output<String>? = null,
    public val eventSystemProperties: Output<List<String>>? = null,
    public val iotHubResourceId: Output<String>? = null,
    public val kind: Output<String>? = null,
    public val kustoPoolName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val mappingRuleName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sharedAccessPolicyName: Output<String>? = null,
    public val tableName: Output<String>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.synapse.IotHubDataConnectionArgs> {
    override fun toJava(): com.pulumi.azurenative.synapse.IotHubDataConnectionArgs =
        com.pulumi.azurenative.synapse.IotHubDataConnectionArgs.builder()
            .consumerGroup(consumerGroup?.applyValue({ args0 -> args0 }))
            .dataConnectionName(dataConnectionName?.applyValue({ args0 -> args0 }))
            .dataFormat(
                dataFormat?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .databaseName(databaseName?.applyValue({ args0 -> args0 }))
            .eventSystemProperties(eventSystemProperties?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .iotHubResourceId(iotHubResourceId?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .kustoPoolName(kustoPoolName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .mappingRuleName(mappingRuleName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sharedAccessPolicyName(sharedAccessPolicyName?.applyValue({ args0 -> args0 }))
            .tableName(tableName?.applyValue({ args0 -> args0 }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IotHubDataConnectionArgs].
 */
@PulumiTagMarker
public class IotHubDataConnectionArgsBuilder internal constructor() {
    private var consumerGroup: Output<String>? = null

    private var dataConnectionName: Output<String>? = null

    private var dataFormat: Output<Either<String, IotHubDataFormat>>? = null

    private var databaseName: Output<String>? = null

    private var eventSystemProperties: Output<List<String>>? = null

    private var iotHubResourceId: Output<String>? = null

    private var kind: Output<String>? = null

    private var kustoPoolName: Output<String>? = null

    private var location: Output<String>? = null

    private var mappingRuleName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var sharedAccessPolicyName: Output<String>? = null

    private var tableName: Output<String>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value The iot hub consumer group.
     */
    @JvmName("plgqldvtajtrisom")
    public suspend fun consumerGroup(`value`: Output<String>) {
        this.consumerGroup = value
    }

    /**
     * @param value The name of the data connection.
     */
    @JvmName("uawxwqerrayldbks")
    public suspend fun dataConnectionName(`value`: Output<String>) {
        this.dataConnectionName = value
    }

    /**
     * @param value The data format of the message. Optionally the data format can be added to each message.
     */
    @JvmName("wlgoaxruyxosjasm")
    public suspend fun dataFormat(`value`: Output<Either<String, IotHubDataFormat>>) {
        this.dataFormat = value
    }

    /**
     * @param value The name of the database in the Kusto pool.
     */
    @JvmName("umkhsfxjbafceoyo")
    public suspend fun databaseName(`value`: Output<String>) {
        this.databaseName = value
    }

    /**
     * @param value System properties of the iot hub
     */
    @JvmName("kticqsfkqsmyvmgq")
    public suspend fun eventSystemProperties(`value`: Output<List<String>>) {
        this.eventSystemProperties = value
    }

    @JvmName("fcrjkgbmumagnoss")
    public suspend fun eventSystemProperties(vararg values: Output<String>) {
        this.eventSystemProperties = Output.all(values.asList())
    }

    /**
     * @param values System properties of the iot hub
     */
    @JvmName("oypwboxlhsesaefa")
    public suspend fun eventSystemProperties(values: List<Output<String>>) {
        this.eventSystemProperties = Output.all(values)
    }

    /**
     * @param value The resource ID of the Iot hub to be used to create a data connection.
     */
    @JvmName("appyokjyysxoqteh")
    public suspend fun iotHubResourceId(`value`: Output<String>) {
        this.iotHubResourceId = value
    }

    /**
     * @param value Kind of the endpoint for the data connection
     * Expected value is 'IotHub'.
     */
    @JvmName("mwevauypghoexryy")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value The name of the Kusto pool.
     */
    @JvmName("bnpustyxgwgsojjm")
    public suspend fun kustoPoolName(`value`: Output<String>) {
        this.kustoPoolName = value
    }

    /**
     * @param value Resource location.
     */
    @JvmName("dsnjhprffptjfuqx")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The mapping rule to be used to ingest the data. Optionally the mapping information can be added to each message.
     */
    @JvmName("egjyyflyiwetqsam")
    public suspend fun mappingRuleName(`value`: Output<String>) {
        this.mappingRuleName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("mywomajfquybhsts")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the share access policy
     */
    @JvmName("mfollkwubyakgtkv")
    public suspend fun sharedAccessPolicyName(`value`: Output<String>) {
        this.sharedAccessPolicyName = value
    }

    /**
     * @param value The table where the data should be ingested. Optionally the table information can be added to each message.
     */
    @JvmName("hrlfelityboaaimr")
    public suspend fun tableName(`value`: Output<String>) {
        this.tableName = value
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("myqymwwsuncerkhq")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value The iot hub consumer group.
     */
    @JvmName("musbiwbdeyguihct")
    public suspend fun consumerGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.consumerGroup = mapped
    }

    /**
     * @param value The name of the data connection.
     */
    @JvmName("rbmkasreqedshnqy")
    public suspend fun dataConnectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataConnectionName = mapped
    }

    /**
     * @param value The data format of the message. Optionally the data format can be added to each message.
     */
    @JvmName("brhecxfiselieeif")
    public suspend fun dataFormat(`value`: Either<String, IotHubDataFormat>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataFormat = mapped
    }

    /**
     * @param value The data format of the message. Optionally the data format can be added to each message.
     */
    @JvmName("adnesyaydxtckjnb")
    public fun dataFormat(`value`: String) {
        val toBeMapped = Either.ofLeft<String, IotHubDataFormat>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataFormat = mapped
    }

    /**
     * @param value The data format of the message. Optionally the data format can be added to each message.
     */
    @JvmName("kehmubxioednnrcm")
    public fun dataFormat(`value`: IotHubDataFormat) {
        val toBeMapped = Either.ofRight<String, IotHubDataFormat>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataFormat = mapped
    }

    /**
     * @param value The name of the database in the Kusto pool.
     */
    @JvmName("kpjysaknsnpxigfd")
    public suspend fun databaseName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databaseName = mapped
    }

    /**
     * @param value System properties of the iot hub
     */
    @JvmName("bwsygibjistoladu")
    public suspend fun eventSystemProperties(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventSystemProperties = mapped
    }

    /**
     * @param values System properties of the iot hub
     */
    @JvmName("wjsafmefqejqchma")
    public suspend fun eventSystemProperties(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.eventSystemProperties = mapped
    }

    /**
     * @param value The resource ID of the Iot hub to be used to create a data connection.
     */
    @JvmName("tgomipfgigjxiyjx")
    public suspend fun iotHubResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iotHubResourceId = mapped
    }

    /**
     * @param value Kind of the endpoint for the data connection
     * Expected value is 'IotHub'.
     */
    @JvmName("bamiecnfnybctnbw")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The name of the Kusto pool.
     */
    @JvmName("wovqxgrbqkludjnr")
    public suspend fun kustoPoolName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kustoPoolName = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("ouwmqgqlabuppgdl")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The mapping rule to be used to ingest the data. Optionally the mapping information can be added to each message.
     */
    @JvmName("cobatlpwscqpjcwq")
    public suspend fun mappingRuleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mappingRuleName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("poyrnhclgkffaxqx")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the share access policy
     */
    @JvmName("temmraksfqrtshhv")
    public suspend fun sharedAccessPolicyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sharedAccessPolicyName = mapped
    }

    /**
     * @param value The table where the data should be ingested. Optionally the table information can be added to each message.
     */
    @JvmName("liipwadssoweuqvn")
    public suspend fun tableName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tableName = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("kyqbjlsbevplrvfa")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): IotHubDataConnectionArgs = IotHubDataConnectionArgs(
        consumerGroup = consumerGroup,
        dataConnectionName = dataConnectionName,
        dataFormat = dataFormat,
        databaseName = databaseName,
        eventSystemProperties = eventSystemProperties,
        iotHubResourceId = iotHubResourceId,
        kind = kind,
        kustoPoolName = kustoPoolName,
        location = location,
        mappingRuleName = mappingRuleName,
        resourceGroupName = resourceGroupName,
        sharedAccessPolicyName = sharedAccessPolicyName,
        tableName = tableName,
        workspaceName = workspaceName,
    )
}
