@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin

import com.pulumi.azurenative.synapse.KustoPoolPrincipalAssignmentArgs.builder
import com.pulumi.azurenative.synapse.kotlin.enums.ClusterPrincipalRole
import com.pulumi.azurenative.synapse.kotlin.enums.PrincipalType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Class representing a cluster principal assignment.
 * Azure REST API version: 2021-06-01-preview. Prior API version in Azure Native 1.x: 2021-04-01-preview.
 * ## Example Usage
 * ### KustoPoolPrincipalAssignmentsCreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var kustoPoolPrincipalAssignment = new AzureNative.Synapse.KustoPoolPrincipalAssignment("kustoPoolPrincipalAssignment", new()
 *     {
 *         KustoPoolName = "kustoclusterrptest4",
 *         PrincipalAssignmentName = "kustoprincipal1",
 *         PrincipalId = "87654321-1234-1234-1234-123456789123",
 *         PrincipalType = AzureNative.Synapse.PrincipalType.App,
 *         ResourceGroupName = "kustorptest",
 *         Role = AzureNative.Synapse.ClusterPrincipalRole.AllDatabasesAdmin,
 *         TenantId = "12345678-1234-1234-1234-123456789123",
 *         WorkspaceName = "synapseWorkspaceName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/synapse/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := synapse.NewKustoPoolPrincipalAssignment(ctx, "kustoPoolPrincipalAssignment", &synapse.KustoPoolPrincipalAssignmentArgs{
 * 			KustoPoolName:           pulumi.String("kustoclusterrptest4"),
 * 			PrincipalAssignmentName: pulumi.String("kustoprincipal1"),
 * 			PrincipalId:             pulumi.String("87654321-1234-1234-1234-123456789123"),
 * 			PrincipalType:           pulumi.String(synapse.PrincipalTypeApp),
 * 			ResourceGroupName:       pulumi.String("kustorptest"),
 * 			Role:                    pulumi.String(synapse.ClusterPrincipalRoleAllDatabasesAdmin),
 * 			TenantId:                pulumi.String("12345678-1234-1234-1234-123456789123"),
 * 			WorkspaceName:           pulumi.String("synapseWorkspaceName"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.synapse.KustoPoolPrincipalAssignment;
 * import com.pulumi.azurenative.synapse.KustoPoolPrincipalAssignmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var kustoPoolPrincipalAssignment = new KustoPoolPrincipalAssignment("kustoPoolPrincipalAssignment", KustoPoolPrincipalAssignmentArgs.builder()
 *             .kustoPoolName("kustoclusterrptest4")
 *             .principalAssignmentName("kustoprincipal1")
 *             .principalId("87654321-1234-1234-1234-123456789123")
 *             .principalType("App")
 *             .resourceGroupName("kustorptest")
 *             .role("AllDatabasesAdmin")
 *             .tenantId("12345678-1234-1234-1234-123456789123")
 *             .workspaceName("synapseWorkspaceName")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:synapse:KustoPoolPrincipalAssignment synapseWorkspaceName/kustoclusterrptest4/kustoprincipal1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/kustoPools/{kustoPoolName}/principalAssignments/{principalAssignmentName}
 * ```
 * @property kustoPoolName The name of the Kusto pool.
 * @property principalAssignmentName The name of the Kusto principalAssignment.
 * @property principalId The principal ID assigned to the cluster principal. It can be a user email, application ID, or security group name.
 * @property principalType Principal type.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property role Cluster principal role.
 * @property tenantId The tenant id of the principal
 * @property workspaceName The name of the workspace.
 */
public data class KustoPoolPrincipalAssignmentArgs(
    public val kustoPoolName: Output<String>? = null,
    public val principalAssignmentName: Output<String>? = null,
    public val principalId: Output<String>? = null,
    public val principalType: Output<Either<String, PrincipalType>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val role: Output<Either<String, ClusterPrincipalRole>>? = null,
    public val tenantId: Output<String>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.synapse.KustoPoolPrincipalAssignmentArgs> {
    override fun toJava(): com.pulumi.azurenative.synapse.KustoPoolPrincipalAssignmentArgs =
        com.pulumi.azurenative.synapse.KustoPoolPrincipalAssignmentArgs.builder()
            .kustoPoolName(kustoPoolName?.applyValue({ args0 -> args0 }))
            .principalAssignmentName(principalAssignmentName?.applyValue({ args0 -> args0 }))
            .principalId(principalId?.applyValue({ args0 -> args0 }))
            .principalType(
                principalType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .role(
                role?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .tenantId(tenantId?.applyValue({ args0 -> args0 }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KustoPoolPrincipalAssignmentArgs].
 */
@PulumiTagMarker
public class KustoPoolPrincipalAssignmentArgsBuilder internal constructor() {
    private var kustoPoolName: Output<String>? = null

    private var principalAssignmentName: Output<String>? = null

    private var principalId: Output<String>? = null

    private var principalType: Output<Either<String, PrincipalType>>? = null

    private var resourceGroupName: Output<String>? = null

    private var role: Output<Either<String, ClusterPrincipalRole>>? = null

    private var tenantId: Output<String>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value The name of the Kusto pool.
     */
    @JvmName("viylculmjykpttml")
    public suspend fun kustoPoolName(`value`: Output<String>) {
        this.kustoPoolName = value
    }

    /**
     * @param value The name of the Kusto principalAssignment.
     */
    @JvmName("wpyiqutvmxnrsjkr")
    public suspend fun principalAssignmentName(`value`: Output<String>) {
        this.principalAssignmentName = value
    }

    /**
     * @param value The principal ID assigned to the cluster principal. It can be a user email, application ID, or security group name.
     */
    @JvmName("xvvydubypoitqigg")
    public suspend fun principalId(`value`: Output<String>) {
        this.principalId = value
    }

    /**
     * @param value Principal type.
     */
    @JvmName("ovonpueepxoettxw")
    public suspend fun principalType(`value`: Output<Either<String, PrincipalType>>) {
        this.principalType = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("prjwhtyrygkxqmeo")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Cluster principal role.
     */
    @JvmName("xgwbthlymbgpvkil")
    public suspend fun role(`value`: Output<Either<String, ClusterPrincipalRole>>) {
        this.role = value
    }

    /**
     * @param value The tenant id of the principal
     */
    @JvmName("rglbdlcqmbkppwuh")
    public suspend fun tenantId(`value`: Output<String>) {
        this.tenantId = value
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("nksentgcadxpgyvd")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value The name of the Kusto pool.
     */
    @JvmName("bjgftggaqjiaofpw")
    public suspend fun kustoPoolName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kustoPoolName = mapped
    }

    /**
     * @param value The name of the Kusto principalAssignment.
     */
    @JvmName("paxxgmixqyykqyuv")
    public suspend fun principalAssignmentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.principalAssignmentName = mapped
    }

    /**
     * @param value The principal ID assigned to the cluster principal. It can be a user email, application ID, or security group name.
     */
    @JvmName("gdtvicjxjhwkxsew")
    public suspend fun principalId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.principalId = mapped
    }

    /**
     * @param value Principal type.
     */
    @JvmName("vtfikmhkfgwlwegk")
    public suspend fun principalType(`value`: Either<String, PrincipalType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.principalType = mapped
    }

    /**
     * @param value Principal type.
     */
    @JvmName("yqsgwvmehurgulgk")
    public fun principalType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PrincipalType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.principalType = mapped
    }

    /**
     * @param value Principal type.
     */
    @JvmName("ngjkpqyomsxdtjyn")
    public fun principalType(`value`: PrincipalType) {
        val toBeMapped = Either.ofRight<String, PrincipalType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.principalType = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("gyiqlnudepjgknfy")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Cluster principal role.
     */
    @JvmName("gveuuavwbheethiu")
    public suspend fun role(`value`: Either<String, ClusterPrincipalRole>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.role = mapped
    }

    /**
     * @param value Cluster principal role.
     */
    @JvmName("tqlcqtbcclyuchpr")
    public fun role(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ClusterPrincipalRole>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.role = mapped
    }

    /**
     * @param value Cluster principal role.
     */
    @JvmName("ywtqtbyugtgxjuqh")
    public fun role(`value`: ClusterPrincipalRole) {
        val toBeMapped = Either.ofRight<String, ClusterPrincipalRole>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.role = mapped
    }

    /**
     * @param value The tenant id of the principal
     */
    @JvmName("gwlampodssirwdxi")
    public suspend fun tenantId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tenantId = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("xkxdfjefspqmmycc")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): KustoPoolPrincipalAssignmentArgs = KustoPoolPrincipalAssignmentArgs(
        kustoPoolName = kustoPoolName,
        principalAssignmentName = principalAssignmentName,
        principalId = principalId,
        principalType = principalType,
        resourceGroupName = resourceGroupName,
        role = role,
        tenantId = tenantId,
        workspaceName = workspaceName,
    )
}
