@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin

import com.pulumi.azurenative.synapse.kotlin.outputs.PrivateEndpointResponse
import com.pulumi.azurenative.synapse.kotlin.outputs.PrivateLinkServiceConnectionStateResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.synapse.kotlin.outputs.PrivateEndpointResponse.Companion.toKotlin as privateEndpointResponseToKotlin
import com.pulumi.azurenative.synapse.kotlin.outputs.PrivateLinkServiceConnectionStateResponse.Companion.toKotlin as privateLinkServiceConnectionStateResponseToKotlin

/**
 * Builder for [PrivateEndpointConnection].
 */
@PulumiTagMarker
public class PrivateEndpointConnectionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PrivateEndpointConnectionArgs = PrivateEndpointConnectionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PrivateEndpointConnectionArgsBuilder.() -> Unit) {
        val builder = PrivateEndpointConnectionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): PrivateEndpointConnection {
        val builtJavaResource =
            com.pulumi.azurenative.synapse.PrivateEndpointConnection(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return PrivateEndpointConnection(builtJavaResource)
    }
}

/**
 * A private endpoint connection
 * Azure REST API version: 2021-06-01. Prior API version in Azure Native 1.x: 2021-03-01.
 * Other available API versions: 2021-06-01-preview.
 * ## Example Usage
 * ### Approve private endpoint connection
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateEndpointConnection = new AzureNative.Synapse.PrivateEndpointConnection("privateEndpointConnection", new()
 *     {
 *         PrivateEndpointConnectionName = "ExamplePrivateEndpointConnection",
 *         PrivateLinkServiceConnectionState = new AzureNative.Synapse.Inputs.PrivateLinkServiceConnectionStateArgs
 *         {
 *             Description = "Approved by abc@example.com",
 *             Status = "Approved",
 *         },
 *         ResourceGroupName = "ExampleResourceGroup",
 *         WorkspaceName = "ExampleWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/synapse/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := synapse.NewPrivateEndpointConnection(ctx, "privateEndpointConnection", &synapse.PrivateEndpointConnectionArgs{
 * 			PrivateEndpointConnectionName: pulumi.String("ExamplePrivateEndpointConnection"),
 * 			PrivateLinkServiceConnectionState: &synapse.PrivateLinkServiceConnectionStateArgs{
 * 				Description: pulumi.String("Approved by abc@example.com"),
 * 				Status:      pulumi.String("Approved"),
 * 			},
 * 			ResourceGroupName: pulumi.String("ExampleResourceGroup"),
 * 			WorkspaceName:     pulumi.String("ExampleWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.synapse.PrivateEndpointConnection;
 * import com.pulumi.azurenative.synapse.PrivateEndpointConnectionArgs;
 * import com.pulumi.azurenative.synapse.inputs.PrivateLinkServiceConnectionStateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateEndpointConnection = new PrivateEndpointConnection("privateEndpointConnection", PrivateEndpointConnectionArgs.builder()
 *             .privateEndpointConnectionName("ExamplePrivateEndpointConnection")
 *             .privateLinkServiceConnectionState(PrivateLinkServiceConnectionStateArgs.builder()
 *                 .description("Approved by abc@example.com")
 *                 .status("Approved")
 *                 .build())
 *             .resourceGroupName("ExampleResourceGroup")
 *             .workspaceName("ExampleWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:synapse:PrivateEndpointConnection sql /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/privateEndpointConnections/{privateEndpointConnectionName}
 * ```
 */
public class PrivateEndpointConnection internal constructor(
    override val javaResource: com.pulumi.azurenative.synapse.PrivateEndpointConnection,
) : KotlinCustomResource(javaResource, PrivateEndpointConnectionMapper) {
    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The private endpoint which the connection belongs to.
     */
    public val privateEndpoint: Output<PrivateEndpointResponse>?
        get() = javaResource.privateEndpoint().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> privateEndpointResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Connection state of the private endpoint connection.
     */
    public val privateLinkServiceConnectionState: Output<PrivateLinkServiceConnectionStateResponse>?
        get() = javaResource.privateLinkServiceConnectionState().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    privateLinkServiceConnectionStateResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Provisioning state of the private endpoint connection.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object PrivateEndpointConnectionMapper : ResourceMapper<PrivateEndpointConnection> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.synapse.PrivateEndpointConnection::class == javaResource::class

    override fun map(javaResource: Resource): PrivateEndpointConnection =
        PrivateEndpointConnection(
            javaResource as
                com.pulumi.azurenative.synapse.PrivateEndpointConnection,
        )
}

/**
 * @see [PrivateEndpointConnection].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PrivateEndpointConnection].
 */
public suspend fun privateEndpointConnection(
    name: String,
    block: suspend PrivateEndpointConnectionResourceBuilder.() -> Unit,
): PrivateEndpointConnection {
    val builder = PrivateEndpointConnectionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PrivateEndpointConnection].
 * @param name The _unique_ name of the resulting resource.
 */
public fun privateEndpointConnection(name: String): PrivateEndpointConnection {
    val builder = PrivateEndpointConnectionResourceBuilder()
    builder.name(name)
    return builder.build()
}
